% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{plot.mcdraws}
\alias{plot.mcdraws}
\title{Trace, density and autocorrelation plots}
\usage{
\method{plot}{mcdraws}(x, vnames, nrows, ncols, ask = FALSE, ...)
}
\arguments{
\item{x}{an object of class \code{mcdraws}.}

\item{vnames}{optional character vector to select a subset of parameters.}

\item{nrows}{number of rows in plot layout.}

\item{ncols}{number of columns in plot layout.}

\item{ask}{ask before plotting the next page; default is \code{FALSE}.}

\item{...}{arguments passed to \code{\link[stats]{density}}.}
}
\description{
Trace, density and autocorrelation plots for selected components of an \code{mcdraws} object.
}
\examples{
\donttest{
ex <- mcmcsae_example(n=50)
sampler <- create_sampler(ex$model, data=ex$dat)
sim <- MCMCsim(sampler, store.all=TRUE)
plot(sim, c("beta", "u", "u_sigma", "v_sigma"), ask=TRUE)
}

}
