% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcp-package.R
\docType{package}
\name{mcp-package}
\alias{mcp-package}
\title{Regression with Multiple Change Points}
\description{
The \pkg{mcp} package provides an interface to fit regression models with
multiple change points between generalized linear segments, optionally with
per-segment variance and autocorrelation structures.

The main function of \pkg{mcp} is the \code{mcp()} function, which uses a formula
syntax to specify a wide range of change point models. Based on the supplied
data, formulas, and additional information, it writes JAGS code on the fly
and use \pkg{rstan} to fit the model, optionally in parallel to speed up
sampling. You will need to install JAGS for \code{mcp()} to work.

A large number of post-processing methods can be applied. These include
\itemize{
\item Summarise fits using \code{summary()}, \code{fixef()}, and \code{ranef()}.
\item Visualize fits using \code{plot()} and individual parameters using \code{plot_pars()}.
\item Test hypotheses using \code{hypothesis()} and \code{loo()}.
}

Extensive documentation with worked examples is available at the
\href{http://lindeloev.github.io/mcp}{mcp website}.
}
