% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qual_stat.R
\name{diagTab}
\alias{diagTab}
\title{Creates Contingency Table}
\usage{
diagTab(
  formula = ~.,
  data,
  bysort = NULL,
  dimname = NULL,
  levels = NULL,
  rep = FALSE,
  across = NULL
)
}
\arguments{
\item{formula}{(\code{numeric})\cr a \link{formula} object with the cross-classifying
variables (separated by \code{+}) on the right hand side. If data is wide structure,
the row name of contingency is represented by the variable to the left of
the \code{+} sign, and the col name is the right. If data is long structure, the
classified variable is put on the left of the formula, and the value variable
is put on the right.}

\item{data}{(\code{data.frame} or \code{matrix})\cr a data frame or matrix.}

\item{bysort}{(\code{string})\cr a sorted variable from the col names of \code{data}, and
a grouped variable for reproducibility analysis.}

\item{dimname}{(\code{vector})\cr a character vector define the row name of contingency
table in first variable, and col name in second variable.}

\item{levels}{(\code{vector})\cr a vector of known levels for measurements.}

\item{rep}{(\code{logical})\cr whether to implement the reproducibility like reader
precision or not.}

\item{across}{(\code{string})\cr the across variable to split original data set to
subsets. The between-reader and within-reader precision's across variable
is \code{site} commonly.}
}
\value{
A object \code{matrix} contains the 2x2 contingency table.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

Creates a 2x2 contingency table from the data frame or matrix for the qualitative
performance and reader precision of downstream analysis.
}
\note{
To be attention that if you would like to generate the 2x2 contingency table
for reproducibility analysis, the original data should be long structure and
using the corresponding formula.
}
\examples{
# For qualitative performance with wide data structure
data("qualData")
qualData \%>\% diagTab(formula = ~ CandidateN + ComparativeN)
qualData \%>\%
  diagTab(
    formula = ~ CandidateN + ComparativeN,
    levels = c(1, 0)
  )

# For qualitative performance with long data structure
dummy <- data.frame(
  id = c("1001", "1001", "1002", "1002", "1003", "1003"),
  value = c(1, 0, 0, 0, 1, 1),
  type = c("Test", "Ref", "Test", "Ref", "Test", "Ref")
)
dummy \%>\%
  diagTab(
    formula = type ~ value,
    bysort = "id",
    dimname = c("Test", "Ref"),
    levels = c(1, 0)
  )

# For Between-Reader precision performance
data("PDL1RP")
reader <- PDL1RP$btw_reader
reader \%>\%
  diagTab(
    formula = Reader ~ Value,
    bysort = "Sample",
    levels = c("Positive", "Negative"),
    rep = TRUE,
    across = "Site"
  )
}
\seealso{
\code{\link[=Summary]{Summary()}} for object to calculate diagnostic accuracy criteria.
}
