% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mdaplot.R
\name{mdaplotyy}
\alias{mdaplotyy}
\title{Create line plot with double y-axis}
\usage{
mdaplotyy(
  data,
  type = "l",
  col = mdaplot.getColors(2),
  lty = c(1, 1),
  lwd = c(1, 1),
  pch = (if (type == "b") c(16, 16) else c(NA, NA)),
  cex = 1,
  xlim = NULL,
  ylim = NULL,
  main = attr(data, "name"),
  xlab = attr(data, "xaxis.name"),
  ylab = rownames(data),
  labels = "values",
  show.labels = FALSE,
  lab.cex = 0.65,
  lab.col = "darkgray",
  show.grid = TRUE,
  grid.lwd = 0.5,
  grid.col = "lightgray",
  xticks = NULL,
  xticklabels = NULL,
  xlas = 0,
  ylas = 0,
  show.legend = TRUE,
  legend.position = "topright",
  legend = ylab,
  ...
)
}
\arguments{
\item{data}{a matrix or a data.frame with two rows of values.}

\item{type}{type of the plot ("l" or "b").}

\item{col}{a color for markers or lines (same as \code{plot} parameter) for each series.}

\item{lty}{line type for each series (two values)}

\item{lwd}{line width for each series (two values)}

\item{pch}{a character for markers (same as \code{plot} parameter) for each series (two values).}

\item{cex}{scale factor for the markers}

\item{xlim}{limits for the x axis (if NULL, will be calculated automatically).}

\item{ylim}{limits for the y axis, either list with two vectors (one for each series) or NULL.}

\item{main}{an overall title for the plot (same as \code{plot} parameter).}

\item{xlab}{a title for the x axis (same as \code{plot} parameter).}

\item{ylab}{a title for each of the two y axis (as a vector of two text values).}

\item{labels}{a vector with text labels for data points or one of the following: "names", "indices", "values".}

\item{show.labels}{logical, show or not labels for the data objects.}

\item{lab.cex}{size for data point labels.}

\item{lab.col}{color for data point labels.}

\item{show.grid}{logical, show or not a grid for the plot.}

\item{grid.lwd}{line thinckness (width) for the grid.}

\item{grid.col}{line color for the grid.}

\item{xticks}{values for x ticks.}

\item{xticklabels}{labels for x ticks.}

\item{xlas}{orientation of xticklabels.}

\item{ylas}{orientation of yticklabels (will be applied to both y axes).}

\item{show.legend}{logical show legend with name of each plot series or not}

\item{legend.position}{position of legend if it must be shown}

\item{legend}{values for the legend}

\item{...}{other plotting arguments.}
}
\description{
\code{mdaplotyy} create line plot for two plot series and uses separate y-axis for each.
}
\details{
This plot has properties both \code{mdaplot} and \code{mdaplotg}, so when you specify color,
line properties etc. you have to do it for both plot series.
}
\examples{
# See all examples in the tutorial.

}
\seealso{
\code{\link{mdaplotg}} - to make plots for several sets of data objects (groups of objects).
}
\author{
Sergey Kucheryavskiy (svkucheryavski@gmail.com)
}
