% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sort_by_missingness.R
\name{sort_by_missingness}
\alias{sort_by_missingness}
\title{Sort Variables according to missingness}
\usage{
sort_by_missingness(x, sort_by = "counts", descending = FALSE, ...)
}
\arguments{
\item{x}{A valid R `object` for which `na_counts` are needed.}

\item{sort_by}{One of counts or percents. This determines whether the results are sorted by counts or percentages.}

\item{descending}{Logical. Should missing values be sorted in decreasing order ie largest to smallest? Defaults to FALSE.}

\item{...}{Other arguments to specific functions. See "See also below"}
}
\value{
A `data.frame` object sorted by number/percentage of missing values
}
\description{
Provides a useful way to sort the variables(columns) according
to their missingness.
}
\examples{
sort_by_missingness(airquality, sort_by = "counts")
# sort by percents
sort_by_missingness(airquality, sort_by="percents")
# descending order
sort_by_missingness(airquality, descend = TRUE)
}
\seealso{
\code{\link{get_na_counts}} \code{\link{percent_missing}}
}
