/*
 * Decompiled with CFR 0.152.
 */
package multidendrograms.dendrogram;

import java.awt.Color;
import java.util.LinkedList;
import multidendrograms.dendrogram.figures.Band;
import multidendrograms.dendrogram.figures.Line;
import multidendrograms.types.ProximityType;

public class Clipping {
    private final ProximityType simType;
    private final double minValue;
    private final double maxValue;

    public Clipping(ProximityType proximityType, double d, double d2) {
        this.simType = proximityType;
        this.minValue = d;
        this.maxValue = d2;
    }

    public LinkedList<Line> clipLines(LinkedList<Line> linkedList) {
        LinkedList<Line> linkedList2 = new LinkedList<Line>();
        for (Line line : linkedList) {
            double d;
            double d2 = line.getPosReal().getY();
            if (d2 > (d = line.getLength())) {
                double d3 = d2;
                d2 = d;
                d = d3;
                line.getPosReal().setY(d2);
                line.setLength(d);
            }
            if (this.minValue < d && d2 < this.maxValue) {
                if (d2 < this.minValue) {
                    line.getPosReal().setY(this.minValue);
                }
                if (this.maxValue < d) {
                    line.setLength(this.maxValue);
                }
                linkedList2.add(line);
                continue;
            }
            if (!(d2 <= this.minValue) || !(this.maxValue <= d)) continue;
            line.getPosReal().setY(this.minValue);
            line.setLength(this.maxValue);
            linkedList2.add(line);
        }
        return linkedList2;
    }

    public LinkedList<Band> clipBands(LinkedList<Band> linkedList) {
        LinkedList<Band> linkedList2 = new LinkedList<Band>();
        for (Band band : linkedList) {
            double d;
            double d2;
            double d3 = band.getPosReal().getX();
            double d4 = band.getPosReal().getY();
            double d5 = band.getHeight();
            double d6 = band.getWidth();
            Color color = band.getColor();
            if (this.simType.equals((Object)ProximityType.DISTANCE)) {
                d2 = d4;
                d = d4 + d5;
            } else {
                d2 = d4 - d5;
                d = d4;
            }
            if (d2 <= this.maxValue && d >= this.minValue) {
                if (d2 < this.minValue) {
                    d2 = this.minValue;
                }
                if (d > this.maxValue) {
                    d = this.maxValue;
                }
                d4 = d2;
                d5 = d - d2;
                linkedList2.add(new Band(d3, d4, d5, d6, color));
                continue;
            }
            if (!(d2 <= this.minValue) || !(d >= this.maxValue)) continue;
            d4 = this.minValue;
            d5 = this.maxValue - this.minValue;
            linkedList2.add(new Band(d3, d4, d5, d6, color));
        }
        return linkedList2;
    }
}

