% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compileConsensusClustering.R
\name{compileConsensusClustering}
\alias{compileConsensusClustering}
\title{Compile Consensus Clustering}
\usage{
compileConsensusClustering(
  mcmc_lst,
  D = NULL,
  W = NULL,
  point_estimate_method = "mean",
  construct_cm = TRUE,
  ...
)
}
\arguments{
\item{mcmc_lst}{Output of ``runMCMCChains``.}

\item{D}{The iteration to use from within the chains. Defaults to the largest
possible value, i.e., the length of the chains.}

\item{W}{The number of chains to use in compiling the consensus clustring.
Defaults to the length of ``mcmc_lst`` but can be smaller.}

\item{point_estimate_method}{Point estimate method for allocation
probabilities in semi-supervised views. One of "median" or "mean".}

\item{construct_cm}{Logical indicating if the consensus matrix should be
constructed.}

\item{...}{Arguments passed to ``salso::salso`` for inferring a point
estimate in unsupervised views.}
}
\value{
A named list similar to the output of ``runMCMCChains``.
}
\description{
Performs consensus clustering on a list of MCMC chains from
``runMCMCChains``.
}
\examples{
\donttest{
N <- 500
K <- 4
P <- 10

X <- generateSimulationDataset(K, N, P)
Y <- generateSimulationDataset(K, N, P)
Z <- generateSimulationDataset(K, N, P)

row.names(Z$data) <- row.names(Y$data) <- row.names(X$data)

data_modelled <- list(X$data, Y$data, Z$data)
V <- length(data_modelled)

# This R is much too low for real applications
R <- 1000
thin <- 100

K_max <- 50
K <- rep(K_max, V)

types <- rep("G", V)

n_chains <- 500
mcmc_lst <- runMCMCChains(data_modelled, n_chains, R, thin, types, K = K)
cc <- compileConsensusClustering(mcmc_lst)
}
}
