% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/time_series.R
\name{time_series}
\alias{time_series}
\alias{time_series.list}
\alias{time_series.mds_das}
\alias{time_series.mds_da}
\title{Generate Time Series from Defined Analysis or Analyses}
\usage{
time_series(analysis, ...)

\method{time_series}{list}(analysis, ...)

\method{time_series}{mds_das}(analysis, ...)

\method{time_series}{mds_da}(analysis, deviceevents, exposure = NULL,
  use_hierarchy = T, ...)
}
\arguments{
\item{analysis}{A defined analysis object of class \code{mds_da}, list of
class \code{mds_das}, or a list of objects each of class \code{mds_da},
usually created by \code{define_analyses()}.}

\item{...}{Further arguments for future work.}

\item{deviceevents}{A device-event data frame of class \code{mds_de}, usually
created by \code{deviceevent()}. This should be the same data frame used to 
generate \code{analysis}.}

\item{exposure}{Optional exposure data frame of class \code{mds_e}, usually
created by \code{exposure()}. This should be the same data frame used to 
generate \code{analysis}, if exposure data was used.

Default: \code{NULL} will not consider exposure data.}

\item{use_hierarchy}{Deprecated - do not use. Logical value indicating 
whether device and event hierarchies should be used in counting contingency 
tables for disproportionality analysis.}
}
\value{
A standardized MD-PMS time series data frame of class \code{mds_ts}.

The data frame contains, by defined date levels, the following columns:
\describe{
  \item{nA}{Count of the device & event level of interest. If covariate
  analysis is indicated, this will be at the covariate & device level of
  interest.}
  \item{nB}{Optional. Count of the device & non-event, or if covariate analysis,
  covariate & non-device. \code{nB} will be missing if this is an
  \code{'All'} level analysis.}
  \item{nC}{Optional. Count of the non-device & event, or if covariate analysis,
  non-covariate & device. \code{nC} will be missing if this is an
  \code{'All'} level analysis.}
  \item{nD}{Optional. Count of the non-device & non-event, or if covariate analysis,
  non-covariate & non-device. \code{nD} will be missing if this is an
  \code{'All'} level analysis.}
  \item{ids}{List of all \code{key}s from \code{deviceevents} constituting
  \code{nA}.}
  \item{exposure}{Optional. Count of exposures applicable to \code{nA}. This counts at
  the device and covariate levels but not at the event level. If a matching
  device and/or covariate level is not found, then \code{exposure} will be
  \code{NA}. The exception is an \code{'All'} level analysis, which counts
  exposures across all levels.}
  \item{ids_exposure}{Optional. List of all exposure keys from \code{exposure}
  applicable to \code{nA}.}
}

The \code{mds_ts} class attributes are as follows:
\describe{
  \item{title}{Short description of the analysis.}
  \item{analysis}{The analysis definition of class \code{mds_da}.}
  \item{exposure}{Boolean of whether exposure counts are present.}
  \item{dpa}{Boolean of whether 2x2 contingency table counts are present
  (presumably for disproportionality analysis or 'DPA').}
  \item{dpa_detail}{Optional. If \code{dpa} is \code{TRUE}, \code{list} 
  object containing labels for the DPA contingency table.}
  \item{covar_data}{Optional. If analysis definition includes covariate level 
  or time in-vivo, \code{data.frame} object containing the relevant data.}
}
}
\description{
Creates time series data frame(s) from defined analysis/analyses
(\code{define_analyses()}), device-event data frame 
(\code{deviceevent()}), and optionally, exposure data frame
(\code{exposure()}). If analysis includes covariates or time in-vivo, creates
the relevant supporting data frame.
}
\section{Methods (by class)}{
\itemize{
\item \code{list}: Generate time series from a list

\item \code{mds_das}: Generate time series from a list of defined analyses

\item \code{mds_da}: Generate time series using defined analysis
}}

\examples{
de <- deviceevent(maude, "date_received", "device_name", "event_type")
ex <- exposure(sales, "sales_month", "device_name", count="sales_volume")
da <- define_analyses(de, "device_name", exposure=ex)
# Time series on one analysis
time_series(da, de, ex)
# Time series on multiple analyses
time_series(da[1:3], de, ex)

}
