% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sprt.R
\name{sprt}
\alias{sprt}
\alias{sprt.mds_ts}
\alias{sprt.default}
\title{Sequential Probability Ratio Test}
\usage{
sprt(df, ...)

\method{sprt}{mds_ts}(df, ts_event = c(Count = "nA"), analysis_of = NA,
  ...)

\method{sprt}{default}(df, analysis_of = NA, eval_period = NULL,
  obs_period = 1, h0 = NULL, h1 = NULL, relative_risk = NULL,
  distribution = "poisson", alpha = 0.05, beta = 0.2,
  h1_type = "greater", ...)
}
\arguments{
\item{df}{Required input data frame of class \code{mds_ts} or, for generic
usage, any data frame with the following columns:
\describe{
  \item{time}{Unique times of class \code{Date}}
  \item{event}{Either the event count or rate of class \code{numeric}}
}}

\item{...}{Further arguments passed onto \code{sprt} methods}

\item{ts_event}{Required if \code{df} is of class \code{mds_ts}. Named string
indicating the variable corresponding to the event count (cell A in the 2x2
contingency table). In most cases, the default is the appropriate setting.
See details for alternative options.

Default: \code{c("Count"="nA")} corresponding to the event count column in
\code{mds_ts} objects. Name is generated from \code{mds_ts} metadata.}

\item{analysis_of}{Optional string indicating the English description of what
was analyzed. If specified, this will override the name of the
\code{ts_event} string parameter.

Default: \code{NA} indicates no English description for plain \code{df}
data frames, or \code{ts_event} English description for \code{df} data frames
of class \code{mds_ts}.

Example: \code{"Count of bone cement leakages"}}

\item{eval_period}{Optional positive integer indicating the number of unique
times counting in reverse chronological order to evaluate. This will be used
to establish the default null hypothesis \code{h0}.

Default: \code{NULL} considers all times in \code{df}.}

\item{obs_period}{Required positive integer indicating the number of unique times
in reverse chronological order to observe and test against the null
hypothesis \code{h0}. This cannot be greater than \code{eval_period}. Used
with \code{eval_period} to establish the default null hypothesis \code{h0}.

Default: \code{1} indicates only the latest time in \code{df} constitutes the
observation period.

Example: \code{3} indicates the last three times in \code{df} constitute the
observation period.}

\item{h0}{Optional numeric value representing the null hypothesis. See
details for more.

Default: \code{NULL} estimates the null hypothesis from the evaluation period
\code{eval_period} less the number of observation periods \code{obs_period}.}

\item{h1}{Optional numeric value representing the test/alternative
hypothesis. Either \code{h1} or \code{relative_risk} must be specified. If
both are specified, \code{relative_risk} takes priority. See details for more.

Default: \code{NULL} assumes that \code{relative_risk} is being used to infer
the alternative hypothesis.}

\item{relative_risk}{Optional numeric value representing the relative risk used to
infer the test/alternative hypothesis as follows: \code{h1=relative_risk * h0}.
Either \code{h1} or \code{relative_risk} must be specified. If both are
specified, \code{relative_risk} takes priority. See details for more.

Default: \code{NULL} assumes that \code{h1} is defining the alternative
hypothesis.

Example: \code{1.2} tests if event occurrence is 1.2 times what is specified
by the null hypothesis \code{h0}.}

\item{distribution}{Required distribution to estimate. Must be either
\code{"poisson"} or \code{"normal"}.

Default: \code{"poisson"}}

\item{alpha}{Required Type I error probability between 0 and 1.

Default: \code{0.05}}

\item{beta}{Required Type II error probability between 0 and 1.

Default: \code{0.20}}

\item{h1_type}{Required type of alternative hypothesis. Must be any of three
values: \code{"greater"}, \code{"less"}, or \code{"not equal"}. For a
two-sided test, set to \code{"not equal"}.

Default: \code{"greater"}}
}
\value{
A named list of class \code{mdsstat_test} object, as follows:
\describe{
  \item{test_name}{Name of the test run}
  \item{analysis_of}{English description of what was analyzed}
  \item{status}{Named boolean of whether the test was run. The name contains
  the run status.}
  \item{result}{A standardized list of test run results: \code{statistic}
  for the test statistic, \code{lcl} and \code{ucl} for the set
  confidence bounds, \code{p} for the p-value, \code{signal} status,
  \code{signal_threshold}, and both null \code{h0} and alternative
  hypothesis \code{h1}.}
  \item{params}{The test parameters}
  \item{data}{The data on which the test was run}
}
}
\description{
Test on device-events using Wald's Sequential Probability Ratio Test (SPRT).
Supports both Poisson (default) and normal distribution functions.
}
\details{
Runs Wald's SPRT where the null hypothesis \code{h0} and alternative
hypothesis \code{h1} represent event occurrence in a single time period.
Event occurrence in Wald's context is the number of events in a time period.
However, at the user's discretion, this function allows event occurrence to
be any continuous number (such as event rate).

In typical medical device surveillance, \code{h1} is greater than \code{h0}
or \code{relative_risk} is greater than 1, and \code{h1_type="greater"}. This is
because we wish to detect elevated occurrences of an undesirable event.

For parameter \code{obs_period}, because the input data frame \code{df} is a
time series, \code{sprt()} requires an observation period that

For parameter \code{ts_event}, in the uncommon case where the
device-event count (Cell A) variable is not \code{"nA"}, the name of the
variable may be specified here. A named character
vector may be used where the name is the English description of what was
analyzed. Note that if the parameter \code{analysis_of} is specified, it will
override this name. Example: \code{ts_event=c("Count of Bone Cement
Leakages"="event_count")}
}
\section{Methods (by class)}{
\itemize{
\item \code{mds_ts}: SPRT on mds_ts data

\item \code{default}: SPRT on general data
}}

\examples{
# At minimum, the df parameter and either the h1 or relative_risk parameter
# must be specified.
# Basic Example
data <- data.frame(time=c(1:25), event=as.integer(stats::rnorm(25, 100, 25)))
a1 <- sprt(data, h1=110)
# Example using an mds_ts object
a2 <- sprt(mds_ts[[3]], relative_risk=1.2)

}
\references{
Wald, Abraham (June 1945). "Sequential Tests of Statistical Hypotheses". Annals of Mathematical Statistics. 16 (2): 117-186.

Martin Kulldorff, Robert L. Davis, Margarette Kolczak, Edwin Lewis, Tracy Lieu & Richard Platt (2011) A Maximized Sequential Probability Ratio Test for Drug and Vaccine Safety Surveillance, Sequential Analysis, 30:1, 58-78.

Stephane Mikael Bottine (2015). SPRT: Wald's Sequential Probability Ratio Test. R package version 1.0. https://CRAN.R-project.org/package=SPRT
}
