% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{hydraulics_scalingconductance}
\alias{hydraulics_scalingconductance}
\alias{hydraulics_maximumSoilPlantConductance}
\alias{hydraulics_soilPlantResistances}
\alias{hydraulics_averageRhizosphereResistancePercent}
\alias{hydraulics_findRhizosphereMaximumConductance}
\alias{hydraulics_taperFactorSavage}
\alias{hydraulics_terminalConduitRadius}
\alias{hydraulics_referenceConductivityHeightFactor}
\alias{hydraulics_maximumStemHydraulicConductance}
\alias{hydraulics_rootxylemConductanceProportions}
\title{Scaling from conductivity to conductance}
\usage{
hydraulics_maximumSoilPlantConductance(krhizomax, krootmax, kstemmax, kleafmax)

hydraulics_soilPlantResistances(
  psiSoil,
  psiRhizo,
  psiStem,
  PLCstem,
  psiLeaf,
  krhizomax,
  n,
  alpha,
  krootmax,
  rootc,
  rootd,
  kstemmax,
  stemc,
  stemd,
  kleafmax,
  leafc,
  leafd
)

hydraulics_averageRhizosphereResistancePercent(
  krhizomax,
  n,
  alpha,
  krootmax,
  rootc,
  rootd,
  kstemmax,
  stemc,
  stemd,
  kleafmax,
  leafc,
  leafd,
  psiStep = -0.01
)

hydraulics_findRhizosphereMaximumConductance(
  averageResistancePercent,
  n,
  alpha,
  krootmax,
  rootc,
  rootd,
  kstemmax,
  stemc,
  stemd,
  kleafmax,
  leafc,
  leafd,
  initialValue = 0
)

hydraulics_taperFactorSavage(height)

hydraulics_terminalConduitRadius(height)

hydraulics_referenceConductivityHeightFactor(refheight, height)

hydraulics_maximumStemHydraulicConductance(
  xylemConductivity,
  refheight,
  Al2As,
  height,
  taper = FALSE
)

hydraulics_rootxylemConductanceProportions(L, V)
}
\arguments{
\item{krhizomax}{Maximum rhizosphere hydraulic conductance (defined as flow per leaf surface unit and per pressure drop).}

\item{krootmax}{Maximum root xylem hydraulic conductance (defined as flow per leaf surface unit and per pressure drop).}

\item{kstemmax}{Maximum stem xylem hydraulic conductance (defined as flow per leaf surface unit and per pressure drop).}

\item{kleafmax}{Maximum leaf hydraulic conductance (defined as flow per leaf surface unit and per pressure drop).}

\item{psiSoil}{Soil water potential (in MPa). A scalar or a vector depending on the function.}

\item{psiRhizo}{Water potential (in MPa) in the rhizosphere (root surface).}

\item{psiStem}{Water potential (in MPa) in the stem.}

\item{PLCstem}{Percent loss of conductance (in \%) in the stem.}

\item{psiLeaf}{Water potential (in MPa) in the leaf.}

\item{n, alpha}{Parameters of the Van Genuchten function (rhizosphere vulnerability curve).}

\item{rootc, rootd}{Parameters of the Weibull function for roots (root xylem vulnerability curve).}

\item{stemc, stemd}{Parameters of the Weibull function for stems (stem xylem vulnerability curve).}

\item{leafc, leafd}{Parameters of the Weibull function for leaves (leaf vulnerability curve).}

\item{psiStep}{Water potential precision (in MPa).}

\item{averageResistancePercent}{Average (across water potential values) resistance percent of the rhizosphere, with respect to total resistance (rhizosphere + root xylem + stem xylem).}

\item{initialValue}{Initial value of rhizosphere conductance.}

\item{height}{Plant height (in cm).}

\item{refheight}{Reference plant height of measurement of xylem conductivity (in cm).}

\item{xylemConductivity}{Xylem conductivity as flow per length of conduit and pressure drop (in kg·m-1·s-1·MPa-1).}

\item{Al2As}{Leaf area to sapwood area (in m2·m-2).}

\item{taper}{A boolean flag to indicate correction by taper of xylem conduits (Christoffersen et al. 2017).}

\item{L}{Vector with the length of coarse roots (mm) for each soil layer.}

\item{V}{Vector with the proportion [0-1] of fine roots within each soil layer.}
}
\value{
Values returned for each function are:
\itemize{
  \item{\code{hydraulics_maximumSoilPlantConductance}: The maximum soil-plant conductance, in the same units as the input segment conductances.}
  \item{\code{hydraulics_averageRhizosphereResistancePercent}: The average percentage of resistance due to the rhizosphere, calculated across water potential values.}
  \item{\code{hydraulics_findRhizosphereMaximumConductance}: The maximum rhizosphere conductance value given an average rhizosphere resistance and the vulnerability curves of rhizosphere, root and stem elements.}
  \item{\code{hydraulics_taperFactorSavage}: Taper factor according to Savage et al. (2010).}
}
}
\description{
Functions used to scale from tissue conductivity to conductance of different elements of the continuum.
}
\details{
Details of the hydraulic model are given in the medfate book
}
\references{
Christoffersen, B. O., M. Gloor, S. Fauset, N. M. Fyllas, D. R. Galbraith, T. R. Baker, L. Rowland, R. A. Fisher, O. J. Binks, S. A. Sevanto, C. Xu, S. Jansen, B. Choat, M. Mencuccini, N. G. McDowell, and P. Meir. 2016. Linking hydraulic traits to tropical forest function in a size-structured and trait-driven model (TFS v.1-Hydro). Geoscientific Model Development Discussions 9: 4227–4255.

Savage, V. M., L. P. Bentley, B. J. Enquist, J. S. Sperry, D. D. Smith, P. B. Reich, and E. I. von Allmen. 2010. Hydraulic trade-offs and space filling enable better predictions of vascular structure and function in plants. Proceedings of the National Academy of Sciences of the United States of America 107:22722–7.

Olson, M.E., Anfodillo, T., Rosell, J.A., Petit, G., Crivellaro, A., Isnard, S., \enc{León-Gómez}{Leon-Gomez}, C., \enc{Alvarado-Cárdenas}{Alvarado-Cardenas}, L.O., and Castorena, M. 2014. Universal hydraulics of the flowering plants: Vessel diameter scales with stem length across angiosperm lineages, habits and climates. Ecology Letters 17: 988–997.
}
\seealso{
\code{\link{hydraulics_psi2K}}, \code{\link{hydraulics_supplyFunctionPlot}}, \code{\link{spwb}}, \code{\link{soil}}
}
\author{
Miquel De \enc{Cáceres}{Caceres} Ainsa, CREAF
}
\keyword{internal}
