% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graph.R
\name{edg_to_adjlist}
\alias{edg_to_adjlist}
\title{Edge list to adjlist}
\usage{
edg_to_adjlist(edg)
}
\arguments{
\item{edg}{character matrix with two columns containing the from and to
nodes of the edges.}
}
\value{
a numeric n x n adjacency matrix with n being the number of unique
  entries in \code{edg}.
}
\description{
Transforms an edge list as returned by \link{community_graph} into an
adjlist as required by, e.g., \link{fluency}.
}
\examples{

# get fluency data
data(animal_fluency)

# edge list of fluency graph
edge_list = threshold_graph(animal_fluency[1:3])

# transfrom to adjacency matrix
edg_to_adjlist(edge_list)

}
