% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/data.r
\docType{data}
\name{Control Variables}
\alias{.NAMES}
\alias{.PRECEDENCE}
\alias{.PREFIX}
\alias{.UNIT}
\alias{Control}
\alias{Control Variables}
\title{Control Variables for the memuse Package.}
\format{\preformatted{ chr "best"
}}
\usage{
.UNIT

.NAMES

.PREFIX

.PRECEDENCE
}
\description{
A set of controls which provides (changeable) default values for many
functions in this package.
}
\details{
Currently, there are 4 control data objects: \itemize{ \item \code{.UNIT}
defaults to "best".  The default choice will scale \code{size} values to the
nearest (by scaling factor --- 1024 or 1000 depending on unit prefix).
Other acceptable choices are, for example, "kb" or "kib".  If the user
requests the wrong unit by prefix (e.g., "kb" instead of "kib" when the unit
prefix is IEC), then the correct one will be chosen for the user.

\item \code{.PREFIX} defaults to "IEC".  Acceptable values are "IEC" and
"SI".

\item \code{.NAMES} defaults to "short".  Acceptable values are "short" and
"long".

\item \code{.PRECEDENCE} defaults to "prefix".  Acceptable values are "unit"
and "prefix".

}

All values are case insensitive, in that the correct case will be determined
for the user if the incorrect case is supplied.  For example, if the user
sets \code{.PREFIX <- "si"}, then the correct case ("SI") will be determined
as needed.

For a "human readable" explanation of what these values do, see the package
vignette.
}
\examples{
\dontrun{
mu(2000)
.PREFIX <- "SI"
mu(2000)
}
}
\seealso{
\code{ \link{memuse-class} \link{Constructor} }
}
\keyword{Data}
\keyword{datasets}

