% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/merList.R
\name{fixef.merModList}
\alias{fixef.merModList}
\title{Extract fixed-effects estimates for a merModList}
\usage{
\method{fixef}{merModList}(object, add.dropped = FALSE, ...)
}
\arguments{
\item{object}{any fitted model object from which fixed
  effects estimates can be extracted.}

\item{add.dropped}{for models with rank-deficient design
  matrix, reconstitute the full-length parameter vector by
  adding \code{NA} values in appropriate locations?}

\item{...}{optional additional arguments. Currently
  none are used in any methods.}
}
\value{
a named, numeric vector of fixed-effects estimates.
}
\description{
Extract fixed-effects estimates for a merModList
}
\details{
Extract the estimates of the fixed-effects parameters from a list of
fitted \code{merMod} models. Takes the mean of the individual \code{fixef}
objects for each of the component models in the \code{merModList}.
}
\examples{
sim_list <- replicate(n = 10,
        expr = sleepstudy[sample(row.names(sleepstudy), 180),],
        simplify=FALSE)
fml <- "Reaction ~ Days + (Days | Subject)"
mod <- lmerModList(fml, data = sim_list)
fixef(mod)
}
