% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/resolve.R
\name{resolve}
\alias{resolve}
\alias{min.messydt}
\alias{max.messydt}
\alias{median.messydt}
\alias{mean.messydt}
\alias{modal}
\alias{modal.messydt}
\alias{random}
\alias{random.messydt}
\title{Resolves messy dates into a single value}
\usage{
\method{min}{messydt}(..., na.rm = TRUE)

\method{max}{messydt}(..., na.rm = TRUE)

\method{median}{messydt}(..., na.rm = TRUE)

\method{mean}{messydt}(..., trim = 0, na.rm = TRUE)

modal(..., na.rm = FALSE)

\method{modal}{messydt}(..., na.rm = TRUE)

random(..., size, replace = FALSE, prob = NULL)

\method{random}{messydt}(..., size, replace = FALSE, prob = NULL)
}
\arguments{
\item{...}{a messydt object}

\item{na.rm}{Should NAs be removed? True by default.}

\item{trim}{the fraction (0 to 0.5) of observations to be trimmed
from each end of x before the mean is computed.
Values of trim outside that range are taken as the nearest endpoint.}

\item{size}{a non-negative integer giving the number of items to choose.}

\item{replace}{should sampling be with replacement?}

\item{prob}{a vector of probability weights
for obtaining the elements of the vector being sampled.}
}
\value{
A single scalar or vector of dates
}
\description{
This collection of S3 methods 'resolve' messy dates into a single date
according to some explicit bias,
such as returning the minimum or maximum date,
the mean, median, or modal date,
or a random date from among the possible resolutions for each messy date.
If the date is not 'messy' (i.e. has no annotations)
then just that precise date is returned.
This can be useful for various descriptive or inferential projects.
}
\examples{
d <- as_messydate("2014-01-01..2014-01-31")
d
min(d)
max(d)
mean(d)
median(d)
modal(d)
random(d)
}
