% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stats.R
\name{stats}
\alias{stats}
\alias{maxmax}
\alias{minmin}
\title{Summary data reports for messy dates}
\usage{
maxmax(date)

minmin(date)
}
\arguments{
\item{date}{An \code{mdate} vector}
}
\value{
A statistic describing the \code{mdate} vector.
}
\description{
Provides variable level summaries of \code{mdate} objects to
simplify the creation of data reports with \code{{skimr}}.
}
\details{
Note that individual dates are first expanded and resolved
before a vector level statistic is computed
(e.g. \code{maxmax()} corresponds to the maximum date of the maximum
of the vector resulting from an expanded \code{{mdate}}).
}
\section{Functions}{
\itemize{
\item \code{maxmax}: Calculate the farthest date forward of a \code{mdate} vector

\item \code{minmin}: Calculate the farthest date in the past of a \code{mdate}
vector
}}

\examples{
\dontrun{
d <- tibble::tibble(event = c("Event1", "Event2", "Event3", "Event 4"),
                    messydates = as_messydate(c("2001",
                                                "2001-01-01..2003-12-30",
                                                "{2001, 2002, 2003}",
                                                "33 BC")))
skimr::skim(d)
}
}
