% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/small_funs.R
\name{spherical}
\alias{spherical}
\alias{dlon}
\alias{dlat}
\alias{dx}
\alias{dy}
\title{Transform between spherical coordinates and physical coordinates}
\usage{
dlon(dx, lat, a = 6731000)

dlat(dy, a = 6731000)

dx(dlon, lat, a = 6731000)

dy(dlat, a = 6731000)
}
\arguments{
\item{dx, dy}{interval in meters}

\item{lat}{latitude, in degrees}

\item{a}{radius of the Earth}

\item{dlon, dlat}{interval in degrees}
}
\description{
Transform a longitude or latitude interval into the equivalent in meters depending
on latitude.
}
\examples{

library(data.table)
data(geopotential)
geopotential <- geopotential[date == date[1]]

# Geostrophic wind
geopotential[, c("u", "v") := GeostrophicWind(gh, lon, lat)]  # in meters/second
geopotential[, c("dlon", "dlat") := .(dlon(u, lat), dlat(v))] # in degrees/second
geopotential[, c("u2", "v2") := .(dx(dlon, lat), dy(dlat))]   # again in degrees/second

}
