% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metamerge.R
\name{metamerge}
\alias{metamerge}
\title{Merge pooled results of two meta-analyses}
\usage{
metamerge(
  meta1,
  meta2,
  pooled1,
  pooled2,
  text.pooled1,
  text.pooled2,
  text.w.pooled1,
  text.w.pooled2,
  label1,
  label2,
  backtransf
)
}
\arguments{
\item{meta1}{First meta-analysis object (see Details).}

\item{meta2}{Second meta-analysis object (see Details).}

\item{pooled1}{A character string indicating whether results of
common effect or random effects model should be considered for
first meta-analysis. Either \code{"both"}, \code{"common"} or
\code{"random"}, can be abbreviated.}

\item{pooled2}{A character string indicating whether results of
common effect or random effects model should be considered for
second meta-analysis. Either \code{"both"}, \code{"common"} or
\code{"random"}, can be abbreviated.}

\item{text.pooled1}{A character string used in printouts and forest
plot to label the results from the first meta-analysis.}

\item{text.pooled2}{A character string used in printouts and forest
plot to label the results from the second meta-analysis.}

\item{text.w.pooled1}{A character string used to label weights of
the first meta-analysis.}

\item{text.w.pooled2}{A character string used to label weights of
the second meta-analysis.}

\item{label1}{A character string used to label estimate of
between-study variance and heterogeneity statistics of the first
meta-analysis.}

\item{label2}{A character string used to label estimate of
between-study variance and heterogeneity statistics of the second
meta-analysis.}

\item{backtransf}{A logical indicating whether results should be
back transformed in printouts and plots. If
\code{backtransf=TRUE} (default), results for \code{sm="OR"} are
printed as odds ratios rather than log odds ratios, for example.}
}
\value{
An object of class \code{"meta"} and \code{"metamerge"} with
corresponding generic functions (see \code{\link{meta-object}}).

The following list elements have a different meaning:
\item{TE, seTE, studlab}{Treatment estimate, standard error, and
  study labels (first meta-analyis).}
\item{lower, upper}{Lower and upper confidence interval limits for
  individual studies (first meta-analysis).}
\item{statistic, pval}{Statistic and p-value for test of treatment
  effect for individual studies (first meta-analysis.}
\item{w.common}{Weights of first common effect meta-analysis.}
\item{w.random}{Weights of first random effects meta-analysis.}
\item{k}{Number of studies combined in first meta-analysis.}

Furthermore, meta-analysis results of common effect or random
effects model are taken from first meta-analysis if only random
effects or common effects models are selected from both
meta-analyses (arguments \code{pooled1} and \code{pooled2}).
}
\description{
This function can be used to merge pooled results of two
meta-analyses into a single meta-analysis object. This is, for
example, useful to produce a forest plot of a random-effects
meta-analysis with different estimates of the between-study
variance \eqn{\tau^2}.
}
\details{
In R package \bold{meta}, objects of class \code{"meta"} contain
results of both a common effect and random effects
meta-analysis. This function enables the user to keep the results
of one of these models and to add results from a second
meta-analysis or a sensitivity analysis.

Applications of this function include printing and plotting results
of the common effect or random effects meta-analysis and the
\itemize{
\item trim-and-fill method (\code{\link{trimfill}}),
\item limit meta-analyis (\code{\link[metasens]{limitmeta}} from R
  package \bold{metasens}),
\item Copas selection model (\code{\link[metasens]{copas}} from R
  package \bold{metasens}),
\item robust variance meta-analysis model
  (\code{\link[robumeta]{robu}} from R package \bold{robumeta}).
}

The first argument must be an object created by a meta-analysis
function, e.g., \code{\link{metagen}} or \code{\link{metabin}}. It
is also possible to provide an object created with
\code{\link[metasens]{limitmeta}} or
\code{\link[metasens]{copas}}. In this case, arguments \code{meta2}
and \code{pooled2} will be ignored.

The second meta-analysis could be an object created by a
meta-analysis function or with \code{\link{trimfill}},
\code{\link[metasens]{limitmeta}}, \code{\link[metasens]{copas}},
or \code{\link[robumeta]{robu}}.

The created meta-analysis object only contains the study results
from the first meta-analysis which are shown in printouts and
forest plots. This only makes a difference for meta-analysis
methods where individual study results differ, e.g.,
Mantel-Haenszel and Peto method for binary outcomes (see
\code{\link{metabin}}).

R function \code{\link{metabind}} can be used to print and plot the
results of more than two meta-analyses, however, without showing
individual study results.
}
\examples{
data(Fleiss1993cont)
#
m1 <- metacont(n.psyc, mean.psyc, sd.psyc, n.cont, mean.cont, sd.cont,
  data = Fleiss1993cont, sm = "MD",
  text.random = "Random effects model (REML)", text.w.random = "DL")
#
# Use DerSimonian-Laird estimator of tau2
#
m2 <- update(m1, method.tau = "DL", common = FALSE,
  text.random = "Random effects model (DL)", text.w.random = "DL")
#
# Merge results of the two meta-analyses
#
m12 <- metamerge(m1, m2)
m12
forest(m12, rightcols = c("effect", "ci", "w.common"))

# Show in addition the results for the Paule-Mandel estimate of
# between-study variance
#
m3 <- update(m1, method.tau = "PM",
  text.random = "Random effects moded (PM)", text.w.random = "PM")
#
m123 <- metamerge(m12, m3, pooled2 = "random")
m123

data(Fleiss1993bin)
#
# Mantel-Haenszel method
#
m4 <- metabin(d.asp, n.asp, d.plac, n.plac, data = Fleiss1993bin,
  studlab = paste(study, year), sm = "OR", random = FALSE,
  text.common = "MH method", text.w.common = "MH")
#
# Peto method
#
m5 <- update(m4, method = "Peto", text.common = "Peto method",
  text.w.common = "Peto")
#
# Merge results (show individual results for MH method)
#
m45 <- metamerge(m4, m5)
summary(m45)
forest(m45, digits = 4)
#
# Merge results (show individual results for Peto method)
#
m54 <- metamerge(m5, m4)
summary(m54)
forest(m54)

}
\seealso{
\code{\link{metagen}}, \code{\link{metabind}}
}
\author{
Guido Schwarzer \email{guido.schwarzer@uniklinik-freiburg.de}
}
