% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metaGEplot.R
\name{metaGE.pvalplot}
\alias{metaGE.pvalplot}
\title{Display visual checks of pvalues.}
\usage{
metaGE.pvalplot(Pvalues, Main = "")
}
\arguments{
\item{Pvalues}{A vector containing pvalues.}

\item{Main}{The main to display.(optional)}
}
\value{
No return value, the plot is displayed in the active graphics window.
}
\description{
The function metaGE.pvalplot displays the pvalue distribution and the QQplot of the -log10(pvalues).
}
\examples{
\dontrun{
# Import the data
data("metaData")

# Compute the inter-environment correlation matrix
matCorr <- metaGE.cor(metaData, Threshold = 0.8)

# Fit the Fixed Effect model
FeDF <- metaGE.fit(metaData, matCorr, Method = "Fe")

# Check the pvalues
metaGE.pvalplot(Pvalues = FeDF$PVALUE, Main= "Pvalue Fe")
}
}
