% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{ricker_reproduction_model}
\alias{ricker_reproduction_model}
\title{Ricker reproduction model}
\usage{
ricker_reproduction_model(abundance, reproduction_rate, carrying_capacity)
}
\arguments{
\item{abundance}{\verb{<numeric>} vector (or matrix) of abundances.}

\item{reproduction_rate}{\verb{<numeric>} vector (or matrix) of reproduction rates.}

\item{carrying_capacity}{\verb{<numeric>} vector (or matrix) of carrying capacities.}
}
\value{
\verb{<numeric>} vector (or matrix) of abundances.
}
\description{
An implementation of the "classic" Ricker reproduction model (Ricker, 1954).
}
\details{
\subsection{Equation:}{

\deqn{abundance_{t+1} = abundance_t \cdot e^{reproduction\_rate \cdot (1 - \frac{abundance_t}{carrying\_capacity})}}{abundance_t1 = abundance_t0 * e^(reproduction_rate * (1 - abundance_t0 / carrying_capacity))}

Note that the input should have an equal size and that the input abundance
should be positive for the results to make sense.
}
}
\examples{
ricker_reproduction_model(
    abundance = 10,
    reproduction_rate = 0.25,
    carrying_capacity = 100
)
ricker_reproduction_model(
    abundance = matrix(10, 10, 5),
    reproduction_rate =  0.25,
    carrying_capacity =  100
)
ricker_reproduction_model(
    abundance = matrix(10, 10, 5),
    reproduction_rate =  matrix(seq(-0.5, 0.5, length.out = 25), 10, 5),
    carrying_capacity =  matrix(100, 10, 5)
)
}
\references{
Cabral, J.S. and Schurr, F.M. (2010)
Estimating demographic models for the range dynamics of plant species.
\emph{Global Ecology and Biogeography}, \strong{19}, 85--97.
\doi{10.1111/j.1466-8238.2009.00492.x}

Original model:
Ricker, W.E. (1954) Stock and recruitment.
\emph{Journal of the Fisheries Research Board of Canada}, \strong{11}, 559--623.
\doi{10.1139/f54-039}
}
