% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/remove_ambiguous.R
\name{is_ambiguous}
\alias{is_ambiguous}
\title{Find ambiguous taxon names}
\usage{
is_ambiguous(taxon_names, unknown = TRUE, uncultured = TRUE,
  name_regex = ".", ignore_case = TRUE)
}
\arguments{
\item{taxon_names}{A \code{\link[taxa]{taxmap}} object}

\item{unknown}{If \code{TRUE}, Remove taxa with names the suggest they are
placeholders for unknown taxa (e.g. "unknown ...").}

\item{uncultured}{If \code{TRUE}, Remove taxa with names the suggest they are
assigned to uncultured organisms (e.g. "uncultured ...").}

\item{name_regex}{The regex code to match a valid character in a taxon name.
For example, "[a-z]" would mean taxon names can only be lower case letters.}

\item{ignore_case}{If \code{TRUE}, dont consider the case of the text when
determining a match.}
}
\value{
TRUE/FALSE vector corresponding to \code{taxon_names}
}
\description{
Find taxa with ambiguous names, such as "unknown" or "uncultured".
}
\details{
If you encounter a taxon name that represents an ambiguous taxon that is not
filtered out by this function, let us know and we will add it.
}
