% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculations.R
\name{calc_group_rsd}
\alias{calc_group_rsd}
\title{Relative standard deviations of groups of columns}
\usage{
calc_group_rsd(
  obj,
  data,
  groups,
  cols = NULL,
  other_cols = FALSE,
  out_names = NULL,
  dataset = NULL
)
}
\arguments{
\item{obj}{A \code{\link{taxmap}} object}

\item{data}{The name of a table in \code{obj$data}.}

\item{groups}{Group multiple columns per treatment/group. This should be a
vector of group IDs (e.g. character, integer) the same length as
\code{cols} that defines which samples go in which group. When used, there
will be one column in the output for each unique value in \code{groups}.}

\item{cols}{The columns in \code{data} to use. By
default, all numeric columns are used. Takes one of the following inputs:
\describe{
\item{TRUE/FALSE:}{All/No columns will used.}
\item{Character vector:}{The names of columns to use} \item{Numeric vector:}{The indexes of
columns to use}
\item{Vector of TRUE/FALSE of length equal to the number of columns:}{Use the columns corresponding to \code{TRUE} values.} }}

\item{other_cols}{Preserve in the output non-target columns present in the
input data. New columns will always be on the end. The "taxon_id" column
will be preserved in the front. Takes one of the following inputs:
\describe{
\item{NULL:}{No columns will be added back, not even the taxon id column.}
\item{TRUE/FALSE:}{All/None of the non-target columns will be preserved.}
\item{Character vector:}{The names of columns to preserve}
\item{Numeric vector:}{The indexes of columns to preserve}
\item{Vector of TRUE/FALSE of length equal to the number of columns:}{Preserve the columns corresponding to \code{TRUE} values.}}}

\item{out_names}{The names of count columns in the output. Must be the same
length and order as \code{cols} (or \code{unique(groups)}, if \code{groups} is used).}

\item{dataset}{DEPRECIATED. use "data" instead.}
}
\value{
A tibble
}
\description{
For a given table in a \code{\link{taxmap}} object, split columns by a
grouping factor and return the relative standard deviation for each row in a
table. The relative standard deviation is the standard deviation divided by
the mean of a set of numbers. It is useful for comparing the variation when
magnitude of sets of number are very different.
}
\examples{
# Parse data for examples
x = parse_tax_data(hmp_otus, class_cols = "lineage", class_sep = ";",
                   class_key = c(tax_rank = "taxon_rank", tax_name = "taxon_name"),
                   class_regex = "^(.+)__(.+)$")

# Calculate the RSD for each group
calc_group_rsd(x, "tax_data", hmp_samples$sex)

# Use only some columns
calc_group_rsd(x, "tax_data", hmp_samples$sex[4:20],
                cols = hmp_samples$sample_id[4:20])

# Including all other columns in ouput
calc_group_rsd(x, "tax_data", groups = hmp_samples$sex,
                other_cols = TRUE)

# Inlcuding specific columns in output
calc_group_rsd(x, "tax_data", groups = hmp_samples$sex,
                other_cols = 2)
calc_group_rsd(x, "tax_data", groups = hmp_samples$sex,
                other_cols = "otu_id")

# Rename output columns
calc_group_rsd(x, "tax_data", groups = hmp_samples$sex,
               out_names = c("Women", "Men"))
}
\seealso{
Other calculations: 
\code{\link{calc_diff_abund_deseq2}()},
\code{\link{calc_group_mean}()},
\code{\link{calc_group_median}()},
\code{\link{calc_group_stat}()},
\code{\link{calc_n_samples}()},
\code{\link{calc_obs_props}()},
\code{\link{calc_prop_samples}()},
\code{\link{calc_taxon_abund}()},
\code{\link{compare_groups}()},
\code{\link{counts_to_presence}()},
\code{\link{rarefy_obs}()},
\code{\link{zero_low_counts}()}
}
\concept{calculations}
