% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metafuse.R
\name{datagenerator}
\alias{datagenerator}
\title{simulate data}
\usage{
datagenerator(n = n, beta0 = beta0, family = "gaussian", seed = seed)
}
\arguments{
\item{n}{sample size for each study, a vector of length \code{K}, the number of studies; can also be an scalar, to specify equal sample size}

\item{beta0}{coefficient matrix, with dimension \code{K * p}, where K is the number of studies and p is the number of covariates}

\item{family}{"gaussian" for continuous response, "binomial" for binary response, "poisson" for count response}

\item{seed}{set random seed for data generation}
}
\value{
a simulated data frame will be returned, containing \code{y}, \code{X}, and study ID \code{sid}
}
\description{
Simulate data for demonstration of flarcc.
}
\details{
These data sets are artifical, and used to test out some features of flarcc.
}
\keyword{data}
\keyword{generator}

\examples{
n <- 200    # sample size in each study
K <- 10     # number of studies
p <- 3      # number of covariates in X (including intercept)
N <- n*K    # total sample size

# the coefficient matrix, used this to set desired heterogeneous pattern (depends on p and K)
beta0 <- matrix(c(0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0,0.0, # intercept
                  0.0,0.0,0.0,0.0,0.0,1.0,1.0,1.0,1.0,1.0, # beta_1, etc.
                  0.0,0.0,0.0,0.0,0.5,0.5,0.5,1.0,1.0,1.0), K, p)

# generate a data set, family=c("gaussian", "binomial", "poisson")
data <- datagenerator(n=n, beta0=beta0, family="gaussian", seed=123)
}

