% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kegg.12.R
\docType{data}
\name{kegg.12}
\alias{kegg.12}
\title{Pathway abundance data.}
\format{A list of 2 dataframes for level 1 and level 2 of KEGG pathways.}
\source{
\href{https://gordonlab.wustl.edu/Subramanian_6_14/Nature_2014_Processed_16S_rRNA_datasets.html}{Gordon Lab}
}
\usage{
data(kegg.12)
}
\description{
KEGG pathway abundance data from PICRUSt analysis.
This is monthly longitudinal data of 50 infants from birth to
2 years of life.
}
\examples{
data(kegg.12)
# Load covariate data
data(covar.rm)
# Comparison of pathway relative abundances for some first pathways of level 1 only
# and assuming crosssectional data (to save running time)
path1<-pathway.compare(pathtab=list(kegg.12[[1]][, 1:2]),
mapfile=covar.rm,sampleid="sampleid",pathsum="rel", stat.med="gamlss",
comvar="gender",adjustvar=c("age.sample","bf"), longitudinal="no",
p.adjust.method="fdr", percent.filter=0.05,relabund.filter=0.00005)
taxcomtab.show(taxcomtab=path1$l1, sumvar="path",tax.lev="l2",
tax.select="none", showvar="genderMale", p.adjust.method="fdr",p.cutoff=1)
}
\references{
Subramanian et al. Nature. 2014 Jun 19; 510(7505): 417–421.
(\href{https://www.ncbi.nlm.nih.gov/pmc/articles/PMC4189846/}{PubMed})
}
\keyword{datasets}
