% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/resp_surf.R
\name{plot.resp_surf}
\alias{plot.resp_surf}
\title{Plot the response surface model}
\usage{
\method{plot}{resp_surf}(
  x,
  xlab = NULL,
  ylab = NULL,
  region = "deprecated",
  resolution = 100,
  bins = 10,
  plot_theme = theme_metan(),
  ...
)
}
\arguments{
\item{x}{An object of class \code{resp_surf}}

\item{xlab, ylab}{The label for the x and y axis, respectively. Defaults to
original variable names.}

\item{region}{Deprecated argument. It will be retired in the next release.}

\item{resolution}{The resolution of the contour plot. Defaults to 100. higher
values produce high-resolution plots but may increase the computation time.}

\item{bins}{The number of bins shown in the plot. Defaults to \code{10}.}

\item{plot_theme}{The graphical theme of the plot. Default is
\code{plot_theme = theme_metan()}. For more details, see
\code{\link[ggplot2]{theme}}.}

\item{...}{Currently not used}
}
\value{
An object of class \code{gg, ggplot}.
}
\description{
Plot the response surface model using a contour plot
}
\examples{
\donttest{
library(metan)
# A small toy example

df <- data.frame(
 expand.grid(x = seq(0, 4, by = 1),
             y = seq(0, 4, by = 1)),
 z = c(10, 11, 12, 11, 10,
       14, 15, 16, 15, 14,
       16, 17, 18, 17, 16,
       14, 15, 16, 15, 14,
       10, 11, 12, 11, 10)
)
mod <- resp_surf(df, x, y, resp = z)
plot(mod)
}

}
\author{
Tiago Olivoto \email{tiagoolivoto@gmail.com}
}
