% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/overlay.R
\name{overlay.data.frame}
\alias{overlay.data.frame}
\title{Create an Overlay Plot for Data Frame}
\usage{
\method{overlay}{data.frame}(x, ncol = 4, nrow = 4, color = "black",
  points = TRUE, line = "solid", ylab = NULL, xlab = NULL,
  ylog = FALSE, xlog = FALSE, ...)
}
\arguments{
\item{x}{folded. See \code{\link[fold]{fold}}.}

\item{ncol}{number of panel columns if only one conditioning variable}

\item{nrow}{number of panel rows if only one conditioning variable}

\item{color}{color for points and lines, recycled as necessary}

\item{points}{logical: whether to plot points, recycled as necessary}

\item{line}{character: line types ('none','solid','dashed', etc.  See \code{\link[ggplot2]{geom_line}}). Recycled as necessary}

\item{ylab}{y axis label to override default}

\item{xlab}{x axis label to override default}

\item{ylog}{whether to log-transform y axis data}

\item{xlog}{whether to log-transform x axis data}

\item{...}{currently passed to \code{\link[ggplot2]{facet_wrap}} or \code{\link[ggplot2]{facet_grid}}}
}
\value{
a ggplot, or list of ggplot as required to support panel_by
}
\description{
Creates an overlay plot for class 'data.frame'. Continuous items are plotted vs last continuous item in \code{names(x)}, conditioned (facetted) by up to two categorical items.
}
\seealso{
\code{\link{overlay.folded}}

Other multivariate plots: \code{\link{corsplom}},
  \code{\link{metaplot}}, \code{\link{overlay.folded}}
}
