% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pool_splines.R
\name{pool_all_splines}
\alias{pool_all_splines}
\title{Title Pool meta-analysis estimates and estimates from a regression model.}
\usage{
pool_all_splines(v, meta.df, glm.res)
}
\arguments{
\item{v}{Name of the covariate, which is modeled using an nsk spline.}

\item{meta.df}{Meta-analysis estimates: dataframe with columns variable (covariate name), est (log HR estimate), est.var (estimated variance) and cov.value (covariate values where est and est.var were reported).}

\item{glm.res}{Regression analysis result object.}
}
\value{
List containing pooled estimates of the spline parameters.
}
\description{
Title Pool meta-analysis estimates and estimates from a regression model.
}
\examples{
# Estimate a linear regression model using an individual participant data (IPD):
library(metasplines)
library(splines2)
res <- lm(
  Petal.Width ~
    Species +
    nsk(Sepal.Length, Boundary.knots = c(4.5, 7.5), knots = c(5, 6, 6.5)),
  data=iris)
# "Literature-based" (LB) estimates:
lb.df <- read.table(text=
"variable,     cov.value,  est,  est.var
Sepal.Length,  4.5,	       0,     0
Sepal.Length,  5,	         0.15,  0.01
Sepal.Length,  5.5,	       0.25,  0.01
Sepal.Length,  6,	         0.4,   0.01
Sepal.Length,  6.5,	       0.5,   0.01
Sepal.Length,  8,          0.25,  0.04
", sep=",", header=TRUE)
# Output table with the point estimates and the estimated variances:
pool_splines(v="Sepal.Length", meta.df=lb.df, glm.res=res)

}
