% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/google_scholar.R
\name{meta_google_scholar}
\alias{meta_google_scholar}
\title{Add Google Scholar Metadata}
\usage{
meta_google_scholar(
  .meta = meta(),
  title,
  author,
  publication_date,
  online_date = NULL,
  journal_title = NULL,
  conference_title = NULL,
  volume = NULL,
  issue = NULL,
  firstpage = NULL,
  lastpage = NULL,
  pdf_url = NULL,
  issn = NULL,
  isbn = NULL,
  dissertation_institution = NULL,
  technical_report_institution = NULL,
  technical_report_number = NULL
)
}
\arguments{
\item{.meta}{A \code{meta} object created by \code{\link[=meta]{meta()}} or \code{\link[=as_meta]{as_meta()}}, or returned
by a \verb{meta_*()} object.}

\item{title}{The title of the paper.

The title tag must contain the title of the paper. Don't use it for the
title of the journal or a book in which the paper was published, or for the
name of your repository. This tag is required for inclusion in Google
Scholar.}

\item{author}{A vector of author names.

The \code{author} tag, must contain the authors (and only the actual authors) of
the paper. Don't use it for the author of the website or for contributors
other than authors, e.g., thesis advisors. Author names can be listed
either as "Smith, John" or as "John Smith". Put each author name in a
separate tag and omit all affiliations, degrees, certifications, etc., from
this field. At least one author tag is required for inclusion in Google
Scholar.}

\item{publication_date, online_date}{The date the paper was published in the
journal (\code{publication_date}) or published online (\code{online_date}).

The \code{publication_date} tag must contain the date of publication, i.e., the
date that would normally be cited in references to this paper from other
papers. Don't use it for the date of entry into the repository - that
should go into \code{online_date} instead. Provide full dates in the "2010/5/12"
format if available; or a year alone otherwise. This tag is required for
inclusion in Google Scholar.}

\item{journal_title, conference_title, issn, isbn, volume, issue, firstpage, lastpage}{For journal and conference papers, provide the remaining bibliographic
citation data in the following tags: \code{journal_title} or \code{conference_title},
\code{issn}, \code{isbn}, \code{volume}, \code{issue}, \code{firstpage}, and \code{lastpage.} These
fields must contain sufficient information to identify a reference to this
paper from another document, which is normally all of: (a) journal or
conference name, (b) volume and issue numbers, if applicable, and (c) the
number of the first page of the paper in the volume (or issue) in question.}

\item{pdf_url}{The \verb{<meta>} tags normally apply only to the exact page on
which they're provided. If this page shows only the abstract of the paper
and you have the full text in a separate file, e.g., in the PDF format,
please specify the locations of all full text versions using \code{pdf_url}. The
content of the tag is the absolute URL of the PDF file; for security
reasons, it must refer to a file in the same subdirectory as the HTML
abstract.}

\item{dissertation_institution, technical_report_institution, technical_report_number}{For theses, dissertations, and technical reports, provide the remaining
bibliographic citation data in the following tags:
\code{dissertation_institution}, \code{technical_report_institution} for the name of
the institution and \code{technical_report_number} for the number of the
technical report. As with journal and conference papers, you need to
provide sufficient information to recognize a formal citation to this
document from another article.}
}
\value{
A \code{meta} object, or a set of \verb{<meta>} HTML tags inside an HTML
\verb{<head>} tag. For use in \code{\link[rmarkdown:html_document]{rmarkdown::html_document()}}, \code{\link[shiny:runApp]{shiny::runApp()}},
or other HTML locations.
}
\description{
Add bibliographic metadata to pages in the format expected by Google
Scholar. Please reference the
\href{https://scholar.google.com/intl/en/scholar/inclusion.html#indexing}{Google Scholar Inclusion}
page for the most up-to-date information and instructions. Note that this
function adds the \code{citation_} prefix to all of its arguments; the \code{title}
argument becomes the \code{citation_title} \verb{<meta>} tag.
}
\examples{
meta_google_scholar(
  title = c(
    "The testis isoform of the phosphorylase kinase catalytic subunit (PhK-T)",
    "plays a critical role in regulation of glycogen mobilization in developing lung"
  ),
  author = c(
    "Liu, Li",
    "Rannels, Stephen R.",
    "Falconieri, Mary",
    "Phillips, Karen S.",
    "Wolpert, Ellen B.",
    "Weaver, Timothy E."
  ),
  publication_date = "1996/05/17",
  journal_title = "Journal of Biological Chemistry",
  volume = 271,
  issue = 20,
  firstpage = 11761,
  lastpage = 11766,
  pdf_url = "http://www.example.com/content/271/20/11761.full.pdf"
)

}
\references{
\url{https://scholar.google.com/intl/en/scholar/inclusion.html#indexing}
}
\seealso{
Other meta: 
\code{\link{meta_apple_itunes_app}()},
\code{\link{meta_apple_web_app}()},
\code{\link{meta_general}()},
\code{\link{meta_geo}()},
\code{\link{meta_name}()},
\code{\link{meta_social}()},
\code{\link{meta_tag}()},
\code{\link{meta_viewport}()},
\code{\link{meta}()}
}
\concept{meta}
