% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checks.R
\name{check_ct_data}
\alias{check_ct_data}
\title{Check Control Terminology for a Dataset}
\usage{
check_ct_data(data, metacore, na_acceptable = NULL)
}
\arguments{
\item{data}{Dataset to check}

\item{metacore}{metacore object that contains the specifications for the
dataset of interest. If any variable has different codelists for different
datasets the metacore object will need to be subsetted using
`select_dataset` from the metacore package.}

\item{na_acceptable}{Logical value, set to `NULL` by default, so the
acceptability of missing values is based on if the core for the variable is
"Required" in the `metacore` object. If set to `TRUE` then will
pass check if values are in the control terminology or are missing. If set
to `FALSE`then NA will not be acceptable.}
}
\value{
Given data if all columns pass. It will error otherwise
}
\description{
This function checks that all columns in the dataset only contains the
control terminology as defined by the metacore specification
}
\examples{
library(haven)
library(metacore)
library(magrittr)
load(metacore_example("pilot_ADaM.rda"))
spec <- metacore \%>\% select_dataset("ADSL")
data <- read_xpt(metatools_example("adsl.xpt"))
check_ct_data(data, spec)
}
