% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_data.R
\name{get_meteo_from}
\alias{get_meteo_from}
\title{Get meteorological stations data}
\usage{
get_meteo_from(
  service = c("aemet", "meteocat", "meteoclimatic", "meteogalicia", "ria"),
  options
)
}
\arguments{
\item{service}{Character with the service name (in lower case).}

\item{options}{List with the needed service options. See \code{\link{services_options}} to have more info
about the different services and their options.}
}
\value{
An sf (spatial) object with the stations meteorological data.
}
\description{
Connect and retrieve data from AEMET, SMC and other Spanish meteorological stations services.
}
\details{
Depending on the service and the temporal resolution selected, the variables present can change, but all
services have at least temperature values.
}
\section{API limits}{

Some APIs have limits in terms of the data that can be retrieved with one call. For example, AEMET
only serves daily data for 31 days in one query. See \code{vignette('api_limits', package = 'meteospain')}
for a detailed explanations of those limits and the ways to retrieve longer periods.
}

\section{Cache}{

In order to avoid unnecessary API calls, results of this function are cached in memory with
\code{\link[memoise]{memoise}}. This means that subsequent calls from \code{get_meteo_from} with the same
arguments will be faster as they will not call the meteorological service API. This cache has a maximum
size of 1024 MB and persist 24 hours in the same R session after loading the package.
To forgot the cache, \code{memoise::forget(get_meteo_from)} can be used.
}

\examples{
\donttest{
if (identical(Sys.getenv("NOT_CRAN"), "true")) {
  library(meteospain)
  library(keyring)

  # AEMET (we need a key)
  # key_set('aemet')
  options_for_aemet <- aemet_options(
    'daily',
    start_date = as.Date('2012-01-01'),
    end_date = as.Date('2012-02-01'),
    api_key = key_get('aemet')
  )
  get_meteo_from('aemet', options_for_aemet)
}
}

}
