% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reg_RAE.R
\name{RAE}
\alias{RAE}
\title{Relative Absolute Error (RAE)}
\usage{
RAE(data = NULL, obs, pred, tidy = FALSE, na.rm = TRUE)
}
\arguments{
\item{data}{(Optional) argument to call an existing data frame containing the data.}

\item{obs}{Vector with observed values (numeric).}

\item{pred}{Vector with predicted values (numeric).}

\item{tidy}{Logical operator (TRUE/FALSE) to decide the type of return. TRUE
returns a data.frame, FALSE returns a list; Default : FALSE.}

\item{na.rm}{Logic argument to remove rows with missing values
(NA). Default is na.rm = TRUE.}
}
\value{
an object of class \code{numeric} within a \code{list} (if tidy = FALSE) or within a
\verb{data frame} (if tidy = TRUE).
}
\description{
It estimates the RAC for a continuous predicted-observed dataset.
}
\details{
The RAE normalizes the Mean Absolute Error (MAE) with respect to the
total absolute error. It is calculated as the ratio between the sum of absolute
residuals (error of predictions with respect to observations) and the sum of
absolute errors of observations with respect to its mean.
It presents its lower bound at 0 (perfect fit), and has no upper bound.
It can be used to compare models using different units.
For the formula and more details, see \href{https://adriancorrendo.github.io/metrica/articles/available_metrics_regression.html}{online-documentation}
}
\examples{
\donttest{
set.seed(1)
X <- rnorm(n = 100, mean = 0, sd = 10)
Y <- X + rnorm(n=100, mean = 0, sd = 3)
RAE(obs = X, pred = Y)
}
}
