% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/egp.R
\name{egp2}
\alias{egp2}
\title{Extended generalised Pareto families of Naveau et al. (2016)}
\arguments{
\item{q}{vector of quantiles}

\item{x}{vector of observations}

\item{p}{vector of probabilities}

\item{n}{sample size}

\item{prob}{mixture probability for model \code{type} \code{4}}

\item{kappa}{shape parameter for \code{type} \code{1}, \code{3} and \code{4}}

\item{delta}{additional parameter for \code{type} \code{2}, \code{3} and \code{4}}

\item{sigma}{scale parameter}

\item{xi}{shape parameter}

\item{type}{integer between 0 to 5 giving the model choice}

\item{log}{logical; should the log-density be returned (default to \code{FALSE})?}

\item{unifsamp}{sample of uniform; if provided, the data will be used in place of new uniform random variates}

\item{censoring}{numeric vector of length 2 containing the lower and upper bound for censoring}
}
\description{
Density function, distribution function, quantile function and random generation for the extended generalized Pareto distribution (GPD) with scale and shape parameters.
}
\details{
The extended generalized Pareto families proposed in Naveau \emph{et al.} (2016)
retain the tail index of the distribution while being compliant with the theoretical behavior of extreme
low rainfall. There are five proposals, the first one being equivalent to the GP distribution.
\itemize{
\item \code{type} 0 corresponds to uniform carrier, \eqn{G(u)=u}.
\item \code{type} 1 corresponds to a three parameters family, with carrier \eqn{G(u)=u^\kappa}.
\item \code{type} 2 corresponds to a three parameters family, with carrier \eqn{G(u)=1-V_\delta((1-u)^\delta)}.
\item \code{type} 3 corresponds to a four parameters family, with carrier \deqn{G(u)=1-V_\delta((1-u)^\delta))^{\kappa/2}}.
\item \code{type} 4 corresponds to a five parameter model (a mixture of \code{type} 2, with \eqn{G(u)=pu^\kappa + (1-p)*u^\delta}
}
}
\section{Usage}{
 \code{pegp2(q, prob=NA, kappa=NA, delta=NA, sigma=NA, xi=NA, type=1)}

 \code{degp2(x, prob=NA, kappa=NA, delta=NA, sigma=NA, xi=NA, type=1, log=FALSE)}

 \code{qegp2(p, prob=NA, kappa=NA, delta=NA, sigma=NA, xi=NA, type=1)}

 \code{regp2(n, prob=NA, kappa=NA, delta=NA, sigma=NA, xi=NA, type=1, unifsamp=NULL, censoring=c(0,Inf))}
}

\references{
Naveau, P., R. Huser, P. Ribereau, and A. Hannart (2016), Modeling jointly low, moderate, and heavy rainfall intensities without a threshold selection, \emph{Water Resour. Res.}, 52, 2753-2769, \code{doi:10.1002/2015WR018552}.
}
\author{
Raphael Huser and Philippe Naveau
}
