% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Wdiag.R
\name{.Joint_MLE_NHPP}
\alias{.Joint_MLE_NHPP}
\title{Joint maximum likelihood for the non-homogeneous Poisson Process}
\usage{
.Joint_MLE_NHPP(x, u = NULL, k, q1, q2 = 1, par, M)
}
\arguments{
\item{x}{vector of data}

\item{u}{optional vector of thresholds. If not supplied, then k thresholds between quantiles (q1, q2) will be used}

\item{k}{number of thresholds to consider if \code{u} not supplied}

\item{q1}{lower  quantile to consider for threshold}

\item{q2}{upper quantile to consider for threshold. Default to 1}

\item{par}{starting values for the optimization}

\item{M}{number of superpositions or 'blocks' / 'years' the process corresponds to.
It affects the estimation of \eqn{mu} and \eqn{sigma},
but these can be changed post-hoc to correspond to any number)}
}
\value{
a list with components
\itemize{
\item mle matrix of MLEs above the supplied thresholds; columns are (\eqn{\mu}, \eqn{\sigma}, \eqn{\xi})
\item Cov.all joint asymptotic covariance matrix of all MLEs
\item Cov.mu joint asymptotic covariance matrix of MLEs for \eqn{\mu}
\item Cov.sig joint asymptotic covariance matrix of MLEs for \eqn{\sigma}
\item Cov.xi joint asymptotic covariance matrix of MLEs for \eqn{\xi}
}
}
\description{
Calculates the MLEs of the parameters (\eqn{\mu}, \eqn{\sigma}, \eqn{\xi}), and joint
asymptotic covariance matrix of these MLEs over a range of thresholds as supplied by the user.
}
\author{
Jennifer L. Wadsworth
}
\keyword{internal}
