% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{.rpairbetaspec}
\alias{.rpairbetaspec}
\title{Generates from \eqn{Q_i}{Qi}, the spectral measure of the pairwise Beta model}
\usage{
.rpairbetaspec(n, d, alpha, beta)
}
\arguments{
\item{n}{sample size}

\item{alpha}{concentration parameter}

\item{beta}{vector of all pairwise component (lexicographic order, by row)}
}
\value{
a matrix of samples from the angular distribution

an \code{n} by \code{d} sample from the spectral distribution
}
\description{
This model was introduced in Cooley, Davis and Naveau (2010).
The sample is drawn from a mixture and the algorithm follows from the proof of Theorem 1 in Ballani and Schlather (2011)
and is written in full in Algorithm 1 of Sabourin et al. (2013).
}
\references{
Cooley, D., R.A. Davis and P. Naveau (2010). The pairwise beta distribution: A flexible parametric multivariate model for extremes, \emph{Journal of Multivariate Analysis}, \bold{101}(9), 2103--2117.

Ballani, D. and M. Schlather (2011). A construction principle for multivariate extreme value distributions, \emph{Biometrika}, \bold{98}(3), 633--645.

Sabourin, A., P. Naveau and A. Fougeres (2013). Bayesian model averaging for extremes, \emph{Extremes}, \bold{16}, 325--350.
}
\author{
Leo Belzile
}
\keyword{internal}
