% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/specdens.R
\name{angmeas}
\alias{angmeas}
\title{Rank-based transformation to angular measure}
\usage{
angmeas(x, Rnorm = c("l1", "l2", "linf"), Anorm = c("l1", "l2", "linf",
  "arctan"), marg = c("Frechet", "Pareto"), wgt = c("Euclidean",
  "Empirical"))
}
\arguments{
\item{x}{an \code{n} by \code{d} sample matrix}

\item{Rnorm}{the norm for the radial component}

\item{Anorm}{the norm for the angular component. \code{arctan} is only implemented for \eqn{d=2}}

\item{marg}{choice of marginal transformation, either to Frechet or Pareto scale}

\item{wgt}{weighting function for the equation. Can be based on Euclidean or empirical likelihood for the mean}
}
\value{
a list with arguments \code{ang} for the \eqn{d-1} pseudo-angular sample, \code{rad} with the radial component
and \code{wts} if \code{Rnorm} is set to "\code{l1}" (default).

a list with components
\itemize{
\item \code{ang} matrix of pseudo-angular observations
\item \code{rad} vector of radial contributions
\item \code{wts} empirical or Euclidean likelihood weights for observations
}
}
\description{
The method uses the pseudo-polar transformation for suitable norms, transforming
the data to pseudo-observations, than marginally to unit Frechet or unit Pareto.
Empirical or Euclidean weights are computed and return alongside of the angular and
radial sample
}
\examples{
x <- rmev(n=25, d=3, param=0.5, model="log")
wts <- angmeas(x=x, Rnorm="l1", Anorm="l1", marg="Frechet", wgt="Empirical")
wts2 <- angmeas(x=x, Rnorm="l2", Anorm="l2", marg="Pareto", wgt="Euclidean")
}
\author{
Leo Belzile
}
\references{
Einmahl, J.H.J. and J. Segers (2009). Maximum empirical likelihood estimation of the spectral measure of an extreme-value distribution, \emph{Annals of Statistics}, \bold{37}(5B), 2953--2989.

de Carvalho, M. and B. Oumow and J. Segers and M. Warchol (2013). A Euclidean likelihood estimator for bivariate tail dependence, \emph{Comm. Statist. Theory Methods}, \bold{42}(7), 1176--1192.

Owen, A.B. (2001). \emph{Empirical Likelihood}, CRC Press, 304p.
}

