% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mrl.R
\name{automrl}
\alias{automrl}
\title{Automated mean residual life plots}
\usage{
automrl(xdat, kmax, thresh, plot = TRUE, ...)
}
\arguments{
\item{xdat}{[numeric] vector of observations}

\item{kmax}{[integer] maximum number of order statistics}

\item{thresh}{[numeric] vector of thresholds; if missing, uses all order statistics from the 20th largest until \code{kmax} as candidates}

\item{plot}{[logical] if \code{TRUE} (default), return a plot of the mean residual life plot with the fitted slope
and the chosen threshold}

\item{...}{additional arguments, currently ignored}
}
\value{
a list containing
\itemize{
\item \code{thresh}: selected threshold
\item \code{scale}: scale parameter estimate
\item \code{shape}: shape parameter estimate
}
}
\description{
This function implements the automated proposal from
Section 2.2 of Langousis et al. (2016)
for mean residual life plots. It returns the threshold
that minimize the weighted mean square error and
moment estimators for the scale and shape parameter
based on weighted least squares.
}
\details{
The procedure consists in estimating the usual
}
\references{
Langousis, A., A. Mamalakis, M. Puliga and R. Deidda (2016).
\emph{Threshold detection for the generalized Pareto distribution:
Review of representative methods and application to the
NOAA NCDC daily rainfall database}, Water Resources Research, \strong{52}, 2659--2681.
}
\keyword{internal}
