% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/posteriors.R
\name{posterior_psi_mean}
\alias{posterior_psi_mean}
\alias{posterior_psi_Omega}
\title{Compute posterior moments of the steady-state parameters}
\usage{
posterior_psi_mean(U, D_mat, Sigma, prior_psi_Omega, post_psi_Omega,
  Y_tilde, prior_psi_mean)

posterior_psi_Omega(U, D_mat, Sigma, prior_psi_Omega)
}
\arguments{
\item{U}{\eqn{U} matrix, of size \code{(n_vars*n_determ*(n_lags+1)) * (n_vars*n_determ)}. This can be obtained using \code{\link{build_U}}.}

\item{D_mat}{The \code{D} matrix (from \code{\link{build_DD}}).}

\item{Sigma}{The covariance matrix.}

\item{prior_psi_Omega}{Matrix of size \code{(n_determ*n_vars) * (n_determ*n_vars)} with the prior covariance of the steady-state parameters.}

\item{post_psi_Omega}{The covariance matrix in the posterior, \eqn{\bar{\Omega}_{\Psi}}.}

\item{Y_tilde}{The lag-corrected data matrix (with no missing values) of size \code{n_T * n_vars}.}

\item{prior_psi_mean}{Vector of length \code{n_determ*n_vars} with the prior means of the steady-state parameters.}
}
\value{
The return is:
\item{psi}{The posterior mean (from \code{\link{posterior_psi_mean}})}

\item{psi_Omega}{The posterior variance (from \code{\link{posterior_psi_Omega}})}
}
\description{
Computes the mean and variance of the conditional posterior distribution of the steady-state parameters.
}
\keyword{internal}
