% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statistical.R
\name{mf.statistical}
\alias{mf.statistical}
\alias{mf.statistical.default}
\alias{mf.statistical.formula}
\title{Statistical meta-features}
\usage{
mf.statistical(...)

\method{mf.statistical}{default}(x, y, features = "all", summary = c("mean",
  "sd"), by.class = TRUE, ...)

\method{mf.statistical}{formula}(formula, data, features = "all",
  summary = c("mean", "sd"), by.class = TRUE, ...)
}
\arguments{
\item{...}{Optional arguments to the summary methods.}

\item{x}{A data.frame contained only the input attributes}

\item{y}{A factor response vector with one label for each row/component of x.}

\item{features}{A list of features names or \code{"all"} to include all them.
The details section describes the valid values for this parameter.}

\item{summary}{A list of methods to summarize the results as post-processing
functions. See \link{post.processing} method to more information. (Default:
\code{c("mean", "sd")})}

\item{by.class}{A logical value indicating if the meta-features must be
computed for each group of samples belonging to different output classes.
(Default: TRUE)}

\item{formula}{A formula to define the class column.}

\item{data}{A data.frame dataset contained the input attributes and class}
}
\value{
A list named by the requested meta-features.
}
\description{
Statistical meta-features are the standard statistical measures to
describe the numerical properties of a distribution of data. As it requires
only numerical attributes, the categorical data are transformed to numerical.
}
\details{
The following features are allowed for this method:
 \describe{
   \item{"correlation"}{Represents the absolute correlation between each pair
      of the numeric attributes in the dataset.}
   \item{"covariance"}{Represents the absolute covariance between each pair
      of the numeric attributes in the dataset.}
   \item{"discreteness.degree"}{Represents the degree of discreetness of each
      attribute in the dataset. It is measured using a sparsity measure.}
   \item{"geometric.mean"}{Represents the geometric mean of the numeric
      attributes in the dataset.}
   \item{"harmonic.mean"}{Represents the harmonic mean of the numeric
      attributes in the dataset.}
   \item{"iqr"}{Represents the interquartile range divided by the standard
      deviation of the numeric attributes in the dataset.}
   \item{"kurtosis"}{Represents the kurtosis of the numeric attributes in
      the dataset.}
   \item{"mad"}{Represents the median absolute deviation of the numeric
      attributes in the dataset.}
   \item{"normality"}{Represents the number of attributes that have a normal
      distribution of values. For that it is used the Shapiro-Wilk Normality
      Test with \code{alpha=0.05}.}
   \item{"outliers"}{"Represents the proportion of numeric attributes with
     outliers."}
   \item{"skewness"}{Represents the skewness of the numeric attributes in
      the dataset.}
   \item{"standard.deviation"}{Represents the standard deviation of the
      numeric attributes in the dataset.}
   \item{"trim.mean"}{Represents the trim mean of the numeric attributes in
      the dataset. It is the aritimetic mean excluding the 20% of the lowest
      and hieghest instances.}
   \item{"variance"}{Represents the variance (normalization of the standard
      deviation) of the numeric attributes in the dataset.}
 }
 Each one of these meta-features generate multiple values (by attribute
 and/or class value) and then it is post processed by the summary methods.
 See the \link{post.processing} method for more details about it.

 The categorical attributes is replaced by binaries attributes.
}
\examples{
## Extract all meta-features
mf.statistical(Species ~ ., iris)

## Extract some meta-features
mf.statistical(iris[1:4], iris[5], c("correlation", "variance"))

## Use another summary methods
mf.statistical(Species ~ ., iris, summary=c("min", "median", "max"))

## Compute the mean for each measure without consider the class information
mf.statistical(Species ~ ., iris, summary="mean", by.class=FALSE)
}
\references{
Castiello, C., Castellano, G., & Fanelli, A. M. (2005). Meta-data:
   Characterization of Input Features for Meta-learning. In Proceedings of
   the 2nd International Conference on Modeling Decisions for Artificial
   Intelligence (Vol. 3558, pp. 457-468).

 Ali, S., & Smith, K. a. (2006). On learning algorithm selection for
   classification. Applied Soft Computing, 6(2), 119-138.
}
\seealso{
Other meta.features: \code{\link{mf.discriminant}},
  \code{\link{mf.general}}, \code{\link{mf.infotheo}},
  \code{\link{mf.landmarking}},
  \code{\link{mf.model.based}}
}

