% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mfp2.R
\name{fp}
\alias{fp}
\alias{fp2}
\title{Helper to assign attributes to a variable undergoing FP-transformation}
\usage{
fp(
  x,
  df = 4,
  alpha = 0.05,
  select = 0.05,
  shift = NULL,
  scale = NULL,
  center = TRUE,
  acdx = FALSE,
  powers = NULL
)

fp2(...)
}
\arguments{
\item{x}{a vector representing a continuous variable undergoing
fp-transformation.}

\item{df, alpha, select, shift, scale, center, acdx}{See \code{\link[=mfp2]{mfp2()}}) for details.}

\item{powers}{a vector of powers to be evaluated for \code{x}. Default is \code{NULL}
and \code{powers = c(-2, -1, -0.5, 0, 0.5, 1, 2, 3)} will be used.}

\item{...}{used in alias \code{fp2} to pass arguments.}
}
\value{
The vector \code{x} with new attributes relevant for fp-transformation. All
arguments passed to this function will be stored as attributes.
}
\description{
Used in formula interface to \code{mfp2()}.
}
\section{Functions}{
\itemize{
\item \code{fp2()}: Alias for \code{fp()} - use in formula when both \code{mfp} and \code{mfp2} are loaded to avoid name shadowing.

}}
\examples{

xr = 1:10
fp(xr)
fp2(xr)
}
