% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getGam.R
\name{getGam}
\alias{getGam}
\title{Convert gamViz object to gamObject}
\usage{
getGam(o)
}
\arguments{
\item{o}{a \code{gamViz} object, the output of \link{getViz}.}
}
\description{
Function for converting a \code{gamViz} object to a \code{gamObject}.
It is essentially the inverse of the \link{getViz} function.
}
\examples{
library(mgcViz)
set.seed(2) ## simulate some data...
dat <- gamSim(1,n=1000,dist="normal",scale=2)
b <- gam(y~s(x0)+s(x1, x2)+s(x3), data=dat, method="REML")
a <- getViz(b)
identical(b, getGam(a)) # Must be TRUE
}
