% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/genClayton3.R
\name{genClayton3}
\alias{genClayton3}
\title{Generates survival data from a trivariate Clayton-Oakes model}
\usage{
genClayton3(n, theta, lambdaC1, lambdaC2, lambdaC3)
}
\arguments{
\item{n}{Sample size for the simulated data set.}

\item{theta}{Parameter for the Clayton copula. Must be -1 or larger.}

\item{lambdaC1, lambdaC2, lambdaC3}{Rate parameters for the censoring
times. No censoring occurs if this paramter is equal to 0.}
}
\value{
A data frame containing the following elements:
\describe{
\item{Y1, Y2, Y3:}{Survival times for the simulated data}
\item{Delta1, Delta2, Delta3:}{Censoring indicators for the simulated
data}
}
}
\description{
Generates simulated survival data from a trivariate Clayton-Oakes model,
which can be used to create example data for trivariate survival
function estimation. The marginal distributions are exponential with
rate parameter 1. The joint distribution is defined using a Clayton
copula. The censoring times are also exponentially distributed with
given rate parameters.
}
\section{Details}{

This function simulates data with the following survival function:
F(t1,t2,t3) = [F(t1,0,0)^(-theta) + F(0,t2,0)^(-theta) +
F(0,0,t3) - 2]^(-1/theta)
(The survival function is defined to be equal to 0 if this
quantity is negative.) The marginal survival functions F(t1,0,0),
F(0,t2,0), and F(0,0,t3) are exponentially distributed with rate
parameter 1. After generating survival times Y1, Y2, and Y3 (of
length n) under this distribution, censoring times C1, C2, and C3 (also
of length n) are generated. C1/C2/C3 are generated under an exponential
distribution with rate parameters lambdaC1, lambdaC2, lambdaC3,
respectively. If C1[i]<Y1[i] for a given observation i, then
observation i is considered to be censored (i.e., Delta1[i]=0).
Delta2 and Delta3 are defined in a similar manner. If lambdaC1,
lambdaC2, and/or lambdaC3 is equal to 0, then the corresponding
variable is uncensored (meaning that Delta[i]=1 for all i).
}

\examples{
x <- genClayton3(200, 0, 0.5, 0.5, 0.5)
}
\references{
Clayton, D. "Model for association in bivariate life tables and its
application in epidemiological studies of familial tendency in chronic
disease incidence.", Biometrika (1978) 65:141-151.
Prentice, R., Zhao, S. "The statistical analysis of multivariate
failure time data: A marginal modeling approach", CRC Press (2019).
}
