% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lda_miretrieve.R
\name{plot_perplexity}
\alias{plot_perplexity}
\title{Plot perplexity score of various LDA models}
\usage{
plot_perplexity(
  df,
  start = 2,
  end = 5,
  stopwords = stopwords_miretrieve,
  method = "gibbs",
  control = NULL,
  col.abstract = Abstract,
  col.pmid = PMID,
  title = NULL
)
}
\arguments{
\item{df}{Data frame containing abstracts and PubMed-IDs.}

\item{start}{Integer. Minimum amount of \code{k} topics for the LDA model to fit. Must
be >=2.}

\item{end}{Integer. Maximum amount of \code{k} topics for the LDA model to fit.}

\item{stopwords}{Data frame containing stop words.}

\item{method}{String. Either \code{"gibbs"} or \code{"VEM"}.}

\item{control}{Control parameters for LDA modeling. For more information,
see the documentation of the \code{LDAcontrol} class in the \pkg{topicmodels}
package.}

\item{col.abstract}{Column containing abstracts.}

\item{col.pmid}{Column containing PubMed-ID.}

\item{title}{String. Plot title.}
}
\value{
Elbow plot displaying perplexity scores of different LDA models.
}
\description{
Plot perplexity score of various LDA models.
}
\details{
Plot perplexity score of various LDA models. \code{plot_perplexity()} fits
different LDA models for \code{k} topics in the range
between \code{start} and \code{end}. For each
LDA model, the perplexity score is plotted against the corresponding value of
\code{k}.
Plotting the perplexity score of various LDA models
can help in identifying the optimal number of topics to fit an LDA model for.
\code{plot_perplexity()} is based on \code{LDA()} from the package
\pkg{topicmodels}.
}
\seealso{
\code{\link[=fit_lda]{fit_lda()}}

Other LDA functions: 
\code{\link{assign_topic_lda}()},
\code{\link{fit_lda}()},
\code{\link{plot_lda_term}()}
}
\concept{LDA functions}
