% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/polymorphism.R
\name{subset_snp}
\alias{subset_snp}
\title{Subset data frame for specific SNPs}
\usage{
subset_snp(df, snp.retain, col.snp = SNPs)
}
\arguments{
\item{df}{Data frame containing SNPs.}

\item{snp.retain}{Character vector. Vector specifying which SNPs to keep.
SNPs in \code{snp.retain} must match SNPs in \code{col.snp} in \code{df}.}

\item{col.snp}{Symbol. Column containing SNPs.}
}
\value{
Data frame containing only specified SNPs.
If no SNP in \code{snp.retain} matches a SNP in \code{col.snp}, \code{subset_snp()} stops
with a warning saying \emph{"No SNP in 'snp.retain' matches a SNP in 'col.snp'.
Could not filter for SNP."}.
}
\description{
Subset data frame for specific SNPs only.
}
\details{
Subset data frame for specific SNPs only.
}
\seealso{
\code{\link[=extract_snp]{extract_snp()}},
\code{\link[=count_snp]{count_snp()}},
\code{\link[=get_snp]{get_snp()}}

Other subset functions: 
\code{\link{subset_df}()},
\code{\link{subset_mir_threshold}()},
\code{\link{subset_mir}()},
\code{\link{subset_research}()},
\code{\link{subset_review}()},
\code{\link{subset_year}()}
}
\concept{subset functions}
