% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subset_mir.R
\name{subset_mir_threshold}
\alias{subset_mir_threshold}
\title{Subset data frame for miRNA names exceeding a threshold}
\usage{
subset_mir_threshold(df, threshold = 1, col.mir = miRNA, col.pmid = PMID)
}
\arguments{
\item{df}{Data frame containing miRNA names and a PubMed-IDs.}

\item{threshold}{Integer or float. If \code{threshold} >= 1, retains
miRNA names in at least \code{threshold} abstracts.
If \code{threshold} is between 0 and 1, retains miRNA names mentioned
in at least \code{threshold} abstracts of all abstracts in \code{df}.}

\item{col.mir}{Symbol. Column containing miRNA names.}

\item{col.pmid}{Symbol. Column containing PubMed-IDs.}
}
\value{
Data frame, subset for miRNA names whose frequency exceeds a
threshold.
}
\description{
Subset data frame for miRNA names whose frequency exceeds a threshold.
}
\details{
Subset data frame for miRNA names whose frequency exceeds a threshold.
This threshold can either
be an absolute value, e.g. 3, or a float between 0 and 1, e.g. 0.2.
If \code{threshold} is an absolute value, \code{subset_mir_threshold()} retains
miRNA names mentioned in at least \code{threshold} abstracts.
If \code{threshold} is a float between 0 and 1, \code{subset_mir_threshold()} retains
miRNA names mentioned in at least \code{threshold} abstracts
of all abstracts in \code{df}.
}
\seealso{
\code{\link[=get_mir]{get_mir()}}, \code{\link[=subset_mir]{subset_mir()}}

Other subset functions: 
\code{\link{subset_df}()},
\code{\link{subset_mir}()},
\code{\link{subset_research}()},
\code{\link{subset_review}()},
\code{\link{subset_snp}()},
\code{\link{subset_year}()}
}
\concept{subset functions}
