% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/impute_boot.R
\name{impute.boot}
\alias{impute.boot}
\title{Bootstrapping Imputation for Many Chemicals}
\usage{
impute.boot(X, DL, Z = NULL, K = 5L)
}
\arguments{
\item{X}{A numeric vector, matrix, or data-frame of chemical concentration levels with n subjects and C chemicals to be imputed. Missing values are indicated by NA's.  Ideally, a numeric matrix.}

\item{DL}{The detection limit for each chemical as a numeric vector with length equal to C chemicals. Vector must be complete (no NA's); any chemical that has a missing detection limit is not imputed. If DL is a data-frame or matrix with 1 row or 1 column, it is forced as a numeric vector.}

\item{Z}{Any covariates used in imputing the chemical concentrations.  Ideally, a numeric matrix; however, Z can be a factor, vector, or data-frame. Assumed to be complete; observations with missing covariate variables are ignored in the imputation, with a warning printed. If none, enter NULL.}

\item{K}{A natural number of imputed datasets to generate. Defaults: 5L.}
}
\value{
A list of: \describe{
     \item{X.imputed}{A number of subjects (n) x number of chemicals (c) x K array of imputed X values.}
     \item{bootstrap_index}{A n x K matrix of bootstrap indices selected for the imputation.}
     \item{indicator.miss}{A check; the sum of imputed  missing values above detection limit,
         which should be 0.}
}
}
\description{
If many chemicals have values below the detection limit, this function creates an imputed dataset using a bootstrap procedure as described in Lubin et al. 2004. It repeatedly invokes \code{\link{impute.Lubin}}().
}
\note{
Note #1: Code was adapted from Erin E. Donahue's original translation of the SAS macro developed from the paper.

      Note #2: No seed is set. Please set seed so the same bootstraps are selected.

      Note #3: If the length of the DL parameter is greater than the number of components, the smallest value is assumed to be a detection limit. A warning is printed to screen.
}
\examples{
data("simdata87")
# Impute using one covariate.
l <- impute.boot(X = simdata87$X.bdl, DL = simdata87$DL, Z = simdata87$Z.sim[, 1], K = 2)
apply(l$X.imputed, 2:3, summary)
}
\references{
Lubin, J. H., Colt, J. S., Camann, D., Davis, S., Cerhan, J. R., Severson, R. K., … Hartge, P. (2004).
Epidemiologic Evaluation of Measurement Data in the Presence of Detection Limits. Environmental Health Perspectives,
 112(17), 1691–1696. https://doi.org/10.1289/ehp.7199
}
\seealso{
Other imputation: \code{\link{impute.Lubin}},
  \code{\link{impute.multivariate.bayesian}},
  \code{\link{impute.sub}}
}
\concept{imputation}
\keyword{imputation}
\keyword{models}
