% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checkStoichiom.R
\name{checkStoichiom}
\alias{checkStoichiom}
\title{Checks whether the stoichiometries in each MFG conserve mass
within a specified tolerance 
If they do not then if reBalanceStoichiom=TRUE
the stoichiometry will be adjusted}
\usage{
checkStoichiom(stoichiom, Rtype, microbeNames, numPaths, stoiTol,
  reBalanceStoichiom = FALSE)
}
\arguments{
\item{stoichiom}{Array. stoichiom[gname,R,path]}

\item{Rtype}{Resource type}

\item{microbeNames}{Vector of strings which contains the names of the
microbial groups in the system e.g. c('Bacteroides','Acetogens')}

\item{numPaths}{Named vector. Number of paths for each microbial group}

\item{stoiTol}{Scalar. tolerance i.e. if abs(prod-up)>stoiTol then warnings are given}

\item{reBalanceStoichiom}{Logical to turn off or on rebalancing}
}
\value{
new stoichiom matrix
}
\description{
Checks whether the stoichiometries in each MFG conserve mass
within a specified tolerance 
If they do not then if reBalanceStoichiom=TRUE
the stoichiometry will be adjusted
}
