% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trans_alpha.R
\name{trans_alpha}
\alias{trans_alpha}
\title{Create trans_alpha object for alpha diveristy statistics and plotting.}
\description{
This class is a wrapper for a series of alpha diveristy related analysis, including the statistics and plotting based on 
An et al. (2019) <doi:10.1016/j.geoderma.2018.09.035> and Paul et al. (2013) <doi:10.1371/journal.pone.0061217>.
}
\examples{

## ------------------------------------------------
## Method `trans_alpha$new`
## ------------------------------------------------

\donttest{
data(dataset)
t1 <- trans_alpha$new(dataset = dataset, group = "Group")
}

## ------------------------------------------------
## Method `trans_alpha$cal_diff`
## ------------------------------------------------

\donttest{
t1$cal_diff(method = "KW")
t1$cal_diff(method = "KW_dunn")
t1$cal_diff(method = "anova")
}

## ------------------------------------------------
## Method `trans_alpha$plot_alpha`
## ------------------------------------------------

\donttest{
t1$plot_alpha(measure = "Shannon", group = "Group")
}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{trans_alpha$new()}}
\item \href{#method-cal_diff}{\code{trans_alpha$cal_diff()}}
\item \href{#method-plot_alpha}{\code{trans_alpha$plot_alpha()}}
\item \href{#method-print}{\code{trans_alpha$print()}}
\item \href{#method-clone}{\code{trans_alpha$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{trans_alpha$new(dataset = NULL, group = NULL, order_x = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{dataset}}{the object of \code{\link{microtable}} Class.}

\item{\code{group}}{default NULL; the sample column used for the statistics; If provided, can return data_stat.}

\item{\code{order_x}}{default NULL; sample_table column name or a vector containg sample names; if provided, order samples by using factor.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
data_alpha and data_stat stored in the object.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\donttest{
data(dataset)
t1 <- trans_alpha$new(dataset = dataset, group = "Group")
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-cal_diff"></a>}}
\if{latex}{\out{\hypertarget{method-cal_diff}{}}}
\subsection{Method \code{cal_diff()}}{
Test the difference of alpha diversity across groups.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{trans_alpha$cal_diff(
  method = c("KW", "KW_dunn", "wilcox", "t.test", "anova")[1],
  measure = NULL,
  p_adjust_method = "fdr",
  anova_set = NULL,
  ...
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{method}}{default "KW"; see the following available options:
\describe{
  \item{\strong{'KW'}}{KW: Kruskal-Wallis Rank Sum Test for all groups (>= 2)}
  \item{\strong{'KW_dunn'}}{Dunn's Kruskal-Wallis Multiple Comparisons, see dunnTest function in FSA package}
  \item{\strong{'wilcox'}}{Wilcoxon Rank Sum and Signed Rank Tests for all paired groups }
  \item{\strong{'t.test'}}{Student's t-Test for all paired groups}
  \item{\strong{'anova'}}{Duncan's multiple range test for anova}
}}

\item{\code{measure}}{default NULL; a vector; if null, all indexes will be calculated; see names of microtable$alpha_diversity, 
e.g. Observed, Chao1, ACE, Shannon, Simpson, InvSimpson, Fisher, Coverage, PD.}

\item{\code{p_adjust_method}}{default "fdr"; p.adjust method; see method parameter of p.adjust function for available options.}

\item{\code{anova_set}}{default NULL; specified group set for anova, such as 'block + N*P*K', see \code{\link{aov}}.}

\item{\code{...}}{parameters passed to kruskal.test or wilcox.test function (method = "KW") or dunnTest function of FSA package (method = "KW_dunn") or
agricolae::duncan.test (method = "anova").}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
res_diff in object. A data.frame generally. A list for anova when anova_set is assigned.
  In the data frame, 'Group' column means that the group has the maximum median or mean value across the test groups;
  For non-parametric methods, maximum median value; For t.test, maximum mean value.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\donttest{
t1$cal_diff(method = "KW")
t1$cal_diff(method = "KW_dunn")
t1$cal_diff(method = "anova")
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-plot_alpha"></a>}}
\if{latex}{\out{\hypertarget{method-plot_alpha}{}}}
\subsection{Method \code{plot_alpha()}}{
Plotting the alpha diveristy.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{trans_alpha$plot_alpha(
  use_diff = TRUE,
  color_values = RColorBrewer::brewer.pal(8, "Dark2"),
  measure = "Shannon",
  group = NULL,
  add_label = "Significance",
  use_boxplot = TRUE,
  boxplot_color = TRUE,
  boxplot_add = "jitter",
  order_x_mean = FALSE,
  y_start = 1.01,
  y_increae = 0.05,
  xtext_angle = NULL,
  xtext_size = 15,
  ytitle_size = 17,
  ...
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{use_diff}}{default TRUE; wheter add significance label using the result of cal_diff function, i.e. object$res_diff;
This is manily designed to add post hoc test of anova or Dunn's Kruskal-Wallis Multiple Comparisons to make the label adding easy.}

\item{\code{color_values}}{default RColorBrewer::brewer.pal(8, "Dark2"); color pallete for groups.}

\item{\code{measure}}{default Shannon; alpha diveristy measurement; see names of alpha_diversity of dataset, 
e.g., Observed, Chao1, ACE, Shannon, Simpson, InvSimpson, Fisher, Coverage, PD.}

\item{\code{group}}{default NULL; group name used for the plot.}

\item{\code{add_label}}{default "Significance"; select a colname of object$res_diff for the label text, such as 'P.adj' or 'Significance'.}

\item{\code{use_boxplot}}{default TRUE; TRUE: boxplot; FALSE: mean-se plot.}

\item{\code{boxplot_color}}{default TRUE; TRUE: use color_values, FALSE: use "black".}

\item{\code{boxplot_add}}{default "jitter"; points type, see the add parameter in ggpubr::ggboxplot.}

\item{\code{order_x_mean}}{default FALSE; whether order x axis by the means of groups from large to small.}

\item{\code{y_start}}{default 1.01; the y axis value from which to add the label; the default 1.01 means 1.01 * max(values).}

\item{\code{y_increae}}{default 0.05; the increasing y axia space to add label; the default 0.05 means 0.05 * y_start; 
this parameter is also used to label the letters of anova result with the fixed (1 + y_increae) * y_start space.}

\item{\code{xtext_angle}}{default NULL; number (e.g. 30) used to make x axis text generate angle.}

\item{\code{xtext_size}}{default 15; x axis text size.}

\item{\code{ytitle_size}}{default 17; y axis title size.}

\item{\code{...}}{parameters pass to ggpubr::ggboxplot function.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
ggplot.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\donttest{
t1$plot_alpha(measure = "Shannon", group = "Group")
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-print"></a>}}
\if{latex}{\out{\hypertarget{method-print}{}}}
\subsection{Method \code{print()}}{
Print the trans_alpha object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{trans_alpha$print()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{trans_alpha$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
