% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trans_diff.R
\name{trans_diff}
\alias{trans_diff}
\title{Create \code{trans_diff} object for the differential analysis on the taxonomic abundance}
\description{
This class is a wrapper for a series of differential abundance test and indicator analysis methods, including 
 LEfSe based on the Segata et al. (2011) <doi:10.1186/gb-2011-12-6-r60>,
 random forest <doi:10.1016/j.geoderma.2018.09.035>, metastat based on White et al. (2009) <doi:10.1371/journal.pcbi.1000352>,
 non-parametric Kruskal-Wallis Rank Sum Test,
 Dunn's Kruskal-Wallis Multiple Comparisons based on the \code{FSA} package, Wilcoxon Rank Sum and Signed Rank Tests, t-test, anova, 
 Scheirer Ray Hare test, 
 R package \code{metagenomeSeq} Paulson et al. (2013) <doi:10.1038/nmeth.2658>, 
 R package \code{ANCOMBC} <doi:10.1038/s41467-020-17041-7>, R package \code{ALDEx2} <doi:10.1371/journal.pone.0067019; 10.1186/2049-2618-2-15>, 
 R package \code{MicrobiomeStat} <doi:10.1186/s13059-022-02655-5>, beta regression <doi:10.18637/jss.v034.i02>, R package \code{maaslin2},
 linear mixed-effects model and generalized linear mixed model.
}
\examples{

## ------------------------------------------------
## Method `trans_diff$new`
## ------------------------------------------------

\donttest{
data(dataset)
t1 <- trans_diff$new(dataset = dataset, method = "lefse", group = "Group")
t1 <- trans_diff$new(dataset = dataset, method = "rf", group = "Group")
t1 <- trans_diff$new(dataset = dataset, method = "metastat", group = "Group", taxa_level = "Genus")
t1 <- trans_diff$new(dataset = dataset, method = "wilcox", group = "Group")
}

## ------------------------------------------------
## Method `trans_diff$plot_diff_abund`
## ------------------------------------------------

\donttest{
t1 <- trans_diff$new(dataset = dataset, method = "anova", group = "Group", taxa_level = "Genus")
t1$plot_diff_abund(use_number = 1:10)
t1$plot_diff_abund(use_number = 1:10, add_sig = TRUE)
t1 <- trans_diff$new(dataset = dataset, method = "wilcox", group = "Group")
t1$plot_diff_abund(use_number = 1:20)
t1$plot_diff_abund(use_number = 1:20, add_sig = TRUE)
t1 <- trans_diff$new(dataset = dataset, method = "lefse", group = "Group")
t1$plot_diff_abund(use_number = 1:20)
t1$plot_diff_abund(use_number = 1:20, add_sig = TRUE)
}

## ------------------------------------------------
## Method `trans_diff$plot_diff_bar`
## ------------------------------------------------

\donttest{
t1$plot_diff_bar(use_number = 1:20)
}

## ------------------------------------------------
## Method `trans_diff$plot_diff_cladogram`
## ------------------------------------------------

\dontrun{
t1$plot_diff_cladogram(use_taxa_num = 100, use_feature_num = 30, select_show_labels = NULL)
}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-trans_diff-new}{\code{trans_diff$new()}}
\item \href{#method-trans_diff-plot_diff_abund}{\code{trans_diff$plot_diff_abund()}}
\item \href{#method-trans_diff-plot_diff_bar}{\code{trans_diff$plot_diff_bar()}}
\item \href{#method-trans_diff-plot_diff_cladogram}{\code{trans_diff$plot_diff_cladogram()}}
\item \href{#method-trans_diff-clone}{\code{trans_diff$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-trans_diff-new"></a>}}
\if{latex}{\out{\hypertarget{method-trans_diff-new}{}}}
\subsection{Method \code{new()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{trans_diff$new(
  dataset = NULL,
  method = c("lefse", "rf", "metastat", "metagenomeSeq", "KW", "KW_dunn", "wilcox",
    "t.test", "anova", "scheirerRayHare", "lm", "ancombc2", "ALDEx2_t", "ALDEx2_kw",
    "DESeq2", "edgeR", "linda", "maaslin2", "betareg", "lme", "glmm", "glmm_beta")[1],
  group = NULL,
  taxa_level = "all",
  filter_thres = 0,
  alpha = 0.05,
  p_adjust_method = "fdr",
  transformation = NULL,
  remove_unknown = TRUE,
  lefse_subgroup = NULL,
  lefse_min_subsam = 10,
  lefse_sub_strict = FALSE,
  lefse_sub_alpha = NULL,
  lefse_norm = 1e+06,
  nresam = 0.6667,
  boots = 30,
  rf_imp_type = 2,
  group_choose_paired = NULL,
  metagenomeSeq_count = 1,
  ALDEx2_sig = c("wi.eBH", "kw.eBH"),
  by_group = NULL,
  by_ID = NULL,
  beta_pseudo = .Machine$double.eps,
  ...
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{dataset}}{default NULL; \code{\link{microtable}} object.}

\item{\code{method}}{default "lefse". Some methods (e.g., "lefse", "KW", "wilcox", "anova", "lm", "betareg", "glmm" and "glmm_beta") 
   invoke the \code{taxa_abund} list (generally relative abundance data) of input microtable object for the analysis.
   Some (e.g., "metastat", "metagenomeSeq", "ALDEx2_t", "DESeq2", "edgeR", "ancombc2" and "linda") use the \code{otu_table} of input microtable object for the analysis. 
   Available options include:
\describe{
  \item{\strong{'lefse'}}{LEfSe method based on Segata et al. (2011) <doi:10.1186/gb-2011-12-6-r60>}
  \item{\strong{'rf'}}{random forest and non-parametric test method based on An et al. (2019) <doi:10.1016/j.geoderma.2018.09.035>}
  \item{\strong{'metastat'}}{Metastat method for all paired groups based on White et al. (2009) <doi:10.1371/journal.pcbi.1000352>}
  \item{\strong{'metagenomeSeq'}}{zero-inflated log-normal model-based differential test method from \code{metagenomeSeq} package.}
  \item{\strong{'KW'}}{KW: Kruskal-Wallis Rank Sum Test for all groups (>= 2)}
  \item{\strong{'KW_dunn'}}{Dunn's Kruskal-Wallis Multiple Comparisons when group number > 2; see dunnTest function in \code{FSA} package}
  \item{\strong{'wilcox'}}{Wilcoxon Rank Sum and Signed Rank Tests for all paired groups }
  \item{\strong{'t.test'}}{Student's t-Test for all paired groups}
  \item{\strong{'anova'}}{ANOVA for one-way or multi-factor analysis; see \code{cal_diff} function of \code{trans_alpha} class}
  \item{\strong{'scheirerRayHare'}}{Scheirer Ray Hare test for nonparametric test used for a two-way factorial experiment; 
        see \code{scheirerRayHare} function of \code{rcompanion} package}
  \item{\strong{'lm'}}{Linear Model based on the \code{lm} function}
  \item{\strong{'ALDEx2_t'}}{runs Welch's t and Wilcoxon tests with \code{ALDEx2} package; see also the test parameter in \code{ALDEx2::aldex} function;
        ALDEx2 uses the centred log-ratio (clr) transformation and estimates per-feature technical variation within each sample using Monte-Carlo instances 
        drawn from the Dirichlet distribution; Reference: <doi:10.1371/journal.pone.0067019> and <doi:10.1186/2049-2618-2-15>; 
        require \code{ALDEx2} package to be installed 
        (\href{https://bioconductor.org/packages/release/bioc/html/ALDEx2.html}{https://bioconductor.org/packages/release/bioc/html/ALDEx2.html})}
  \item{\strong{'ALDEx2_kw'}}{runs Kruskal-Wallace and generalized linear model (glm) test with \code{ALDEx2} package; 
        see also the \code{test} parameter in \code{ALDEx2::aldex} function.}
  \item{\strong{'DESeq2'}}{Differential expression analysis based on the Negative Binomial (a.k.a. Gamma-Poisson) distribution based on the \code{DESeq2} package.}
  \item{\strong{'edgeR'}}{The \code{exactTest} method of \code{edgeR} package is implemented.}
  \item{\strong{'ancombc2'}}{Analysis of Compositions of Microbiomes with Bias Correction (ANCOM-BC) 
     based on the \code{ancombc2} function from \code{ANCOMBC} package.
     If the \code{fix_formula} parameter is not provided, the function can automatically assign it by using group parameter.
     For this method, the \code{group} parameter is directly passed to the group parameter of \code{ancombc2} function.
     Reference: <doi:10.1038/s41467-020-17041-7><10.1038/s41592-023-02092-7>; Require \code{ANCOMBC} package to be installed 
     (\href{https://bioconductor.org/packages/release/bioc/html/ANCOMBC.html}{https://bioconductor.org/packages/release/bioc/html/ANCOMBC.html})}
  \item{\strong{'linda'}}{Linear Model for Differential Abundance Analysis of High-dimensional Compositional Data 
        based on the \code{linda} function of \code{MicrobiomeStat} package. 
        For linda method, please provide either the group parameter or the formula parameter.
        When the formula parameter is provided, it should start with '~' as it is directly used by the linda function.
        If the group parameter is used, the prefix '~' is not necessary as the function can automatically add it.
        The parameter \code{feature.dat.type = 'count'} has been fixed. Other parameters can be passed to the \code{linda} function.
        Reference: <doi:10.1186/s13059-022-02655-5>}
  \item{\strong{'maaslin2'}}{finding associations between metadata and potentially high-dimensional microbial multi-omics data based on the Maaslin2 package.
        Using this option can invoke the \code{trans_env$cal_cor} function with \code{method = "maaslin2"}.}
  \item{\strong{'betareg'}}{Beta Regression based on the \code{betareg} package. 
        Please see the \code{beta_pseudo} parameter for the use of pseudo value when there is 0 or 1 in the data}
  \item{\strong{'lme'}}{Linear Mixed Effect Model based on the \code{lmerTest} package.
        In the return table, the significance of fixed factors are tested by function \code{anova}.
        The significance of 'Estimate' in each term of fixed factors comes from the model.}
  \item{\strong{'glmm'}}{Generalized linear mixed model (GLMM) based on the \code{glmmTMB} package.
        The \code{formula} and \code{family} parameters are needed. 
        Please refer to glmmTMB package to select the family function, e.g. \code{family = glmmTMB::lognormal(link = "log")}.
        The usage of formula is similar with that in 'lme' method.
        For more available parameters, please see \code{glmmTMB::glmmTMB} function and use parameter passing.
        In the result, Conditional R2 and Marginal R2 represent the variance explained by both fixed and random effects and the variance explained by 
        fixed effects, respectively. For more details on R2 calculation, please refer to the article <doi: 10.1098/rsif.2017.0213>.
        The significance of fixed factors are tested by Chi-square test from function \code{car::Anova}.
        The significance of 'Estimate' in each term of fixed factors comes from the model.}
  \item{\strong{'glmm_beta'}}{Generalized linear mixed model with a family function of beta distribution, 
        developed for the relative abundance (ranging from 0 to 1) of taxa specifically. 
        This is an extension of the GLMM model in \code{'glmm'} option.
        The only difference is in \code{glmm_beta} the family function is fixed with the beta distribution function, 
        i.e. \code{family = glmmTMB::beta_family(link = "logit")}.
        Please see the \code{beta_pseudo} parameter for the use of pseudo value when there is 0 or 1 in the data}
}}

\item{\code{group}}{default NULL; sample group used for the comparision; a colname of input \code{microtable$sample_table};
It is necessary when method is not "anova" or method is "anova" but formula is not provided.
Once group is provided, the return res_abund will have mean and sd values for group.}

\item{\code{taxa_level}}{default "all"; 'all' represents using abundance data of all taxonomic ranks; 
For testing at a specific rank, provide taxonomic rank name, such as "Genus".
If the provided taxonomic name is neither 'all' nor a colname in tax_table of input dataset (e.g., "ASV"), 
the function will use the features in input \code{microtable$otu_table} automatically.
Note that a specific level (e.g., "ASV") should be provided for \code{method}: 
"metastat", "metagenomeSeq", "ALDEx2_t", "DESeq2", "edgeR", "ancombc2", "linda", "maaslin2".}

\item{\code{filter_thres}}{default 0; the abundance threshold, such as 0.0005 when the input is relative abundance; only available when method != "metastat".
The features with abundances lower than filter_thres will be filtered.}

\item{\code{alpha}}{default 0.05; significance threshold to select taxa when method is "lefse" or "rf"; 
or used to generate significance letters when method is 'anova' or 'KW_dunn' like the alpha parameter in \code{cal_diff} of \code{trans_alpha} class.}

\item{\code{p_adjust_method}}{default "fdr"; p.adjust method; see method parameter of \code{p.adjust} function for other available options; 
"none" means disable p value adjustment; So when \code{p_adjust_method = "none"}, P.adj is same with P.unadj.}

\item{\code{transformation}}{default NULL; feature abundance transformation method in the class \code{\link{trans_norm}},
such as 'AST' for the arc sine square root transformation.
Only available when \code{method} is one of "KW", "KW_dunn", "wilcox", "t.test", "anova", "scheirerRayHare", "betareg" and "lme".}

\item{\code{remove_unknown}}{default TRUE; whether remove unknown features that donot have clear classification information.}

\item{\code{lefse_subgroup}}{default NULL; sample sub group used for sub-comparision in lefse; Segata et al. (2011) <doi:10.1186/gb-2011-12-6-r60>.}

\item{\code{lefse_min_subsam}}{default 10; sample numbers required in the subgroup test.}

\item{\code{lefse_sub_strict}}{default FALSE; whether remove the features strictly in the sub-checking.
FALSE means only removing the features that have different orders of medians across sub-groups with those across groups and the statistics are also significant.
TRUE means removing the features that are not significant in one (or more) sub-test or have different orders of medians across sub-groups with those across groups.}

\item{\code{lefse_sub_alpha}}{default NULL; The significance threshold in the test for lefse sub-groups. NULL means it is same with \code{alpha}.}

\item{\code{lefse_norm}}{default 1000000; normalization value used in lefse to scale abundances for each level. 
A \code{lefse_norm} value < 0 (e.g., -1) means no normalization same with the LEfSe python version.}

\item{\code{nresam}}{default 0.6667; sample number ratio used in each bootstrap for method = "lefse" or "rf".}

\item{\code{boots}}{default 30; bootstrap test number for method = "lefse" or "rf".}

\item{\code{rf_imp_type}}{default 2; the type of feature importance in random forest when \code{method = "rf"}. 
Same with \code{type} parameter in \code{importance} function of \code{randomForest} package.
1=mean decrease in accuracy (MeanDecreaseAccuracy), 2=mean decrease in node impurity (MeanDecreaseGini).}

\item{\code{group_choose_paired}}{default NULL; a vector used for selecting the required groups for paired testing instead of all paired combinations across groups;
Available when method is "metastat", "metagenomeSeq", "ALDEx2_t" or "edgeR".}

\item{\code{metagenomeSeq_count}}{default 1; Filter features to have at least 'counts' counts.; see the count parameter in MRcoefs function of \code{metagenomeSeq} package.}

\item{\code{ALDEx2_sig}}{default c("wi.eBH", "kw.eBH"); which column of the final result is used as the significance asterisk assignment;
applied to method = "ALDEx2_t" or "ALDEx2_kw"; the first element is provided to "ALDEx2_t"; the second is provided to "ALDEx2_kw";
for "ALDEx2_t", the available choice is "wi.eBH" (Expected Benjamini-Hochberg corrected P value of Wilcoxon test)
and "we.eBH" (Expected BH corrected P value of Welch's t test); for "ALDEx2_kw"; for "ALDEx2_t",
the available choice is "kw.eBH" (Expected BH corrected P value of Kruskal-Wallace test) and "glm.eBH" (Expected BH corrected P value of glm test).}

\item{\code{by_group}}{default NULL; a column of sample_table used to perform the differential test 
among groups (\code{group} parameter) for each group (\code{by_group} parameter). So \code{by_group} has a higher level than \code{group} parameter.
Same with the \code{by_group} parameter in \code{trans_alpha} class. 
Only available when method is one of \code{c("KW", "KW_dunn", "wilcox", "t.test", "anova", "scheirerRayHare")}.}

\item{\code{by_ID}}{default NULL; a column of sample_table used to perform paired t test or paired wilcox test for the paired data,
such as the data of plant compartments for different plant species (ID). 
So \code{by_ID} in sample_table should be the smallest unit of sample collection without any repetition in it.
Same with the \code{by_ID} parameter in trans_alpha class.}

\item{\code{beta_pseudo}}{default .Machine$double.eps; the pseudo value used when the parameter \code{method} is \code{'betareg'} or \code{'glmm_beta'}.
As the beta distribution function limits 0 < response value < 1, a pseudo value will be added for the data that equal to 0.
The data that equal to 1 will be replaced by \code{1/(1 + beta_pseudo)}.}

\item{\code{...}}{parameters passed to \code{cal_diff} function of \code{trans_alpha} class when method is one of 
"KW", "KW_dunn", "wilcox", "t.test", "anova", "betareg", "lme", "glmm" or "glmm_beta";
passed to \code{randomForest::randomForest} function when method = "rf";
passed to \code{ANCOMBC::ancombc2} function when method is "ancombc2" (except tax_level, global and fix_formula parameters);
passed to \code{ALDEx2::aldex} function when method = "ALDEx2_t" or "ALDEx2_kw";
passed to \code{DESeq2::DESeq} function when method = "DESeq2";
passed to \code{MicrobiomeStat::linda} function when method = "linda";
passed to \code{trans_env$cal_cor} function when method = "maaslin2".}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
res_diff and res_abund.\cr
  \strong{res_abund} includes mean abundance of each taxa (Mean), standard deviation (SD), standard error (SE) and sample number (N) in the group (Group).\cr
  \strong{res_diff} is the detailed differential test result depending on the method choice, may containing:\cr
    \strong{"Comparison"}: The groups for the comparision, maybe all groups or paired groups. If this column is not found, all groups are used;\cr
    \strong{"Group"}: Which group has the maximum median or mean value across the test groups; 
       For non-parametric methods, median value; For t.test, mean value;\cr
    \strong{"Taxa"}: which taxa is used in this comparision;\cr
    \strong{"Method"}: Test method used in the analysis depending on the method input;\cr
    \strong{"LDA" or others}: LDA: linear discriminant score in LEfSe; 
    	  MeanDecreaseAccuracy and MeanDecreaseGini: mean decreasing in accuracy or in node impurity (gini index) in random forest;\cr
    \strong{"P.unadj"}: original p value;\cr
    \strong{"P.adj"}: adjusted p value;\cr
    \strong{"Estimate" and "Std.Error"}: When method is "betareg", "lm", "lme" or "glmm", 
       "Estimate" and "Std.Error" represent fitted coefficient and its standard error, respectively;\cr
    \strong{Others}: qvalue: qvalue in metastat analysis.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\donttest{
data(dataset)
t1 <- trans_diff$new(dataset = dataset, method = "lefse", group = "Group")
t1 <- trans_diff$new(dataset = dataset, method = "rf", group = "Group")
t1 <- trans_diff$new(dataset = dataset, method = "metastat", group = "Group", taxa_level = "Genus")
t1 <- trans_diff$new(dataset = dataset, method = "wilcox", group = "Group")
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-trans_diff-plot_diff_abund"></a>}}
\if{latex}{\out{\hypertarget{method-trans_diff-plot_diff_abund}{}}}
\subsection{Method \code{plot_diff_abund()}}{
Plot the abundance of taxa. 

The significance can be optionally added in the plot. 
The taxa displayed are based on the taxa in the 'res_diff' table, selected using parameters. 
If the user filters out the non-significant taxa from the 'res_diff' table, these taxa will also be filtered from the plot.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{trans_diff$plot_diff_abund(
  use_number = 1:10,
  color_values = RColorBrewer::brewer.pal(8, "Dark2"),
  select_taxa = NULL,
  simplify_names = TRUE,
  keep_prefix = TRUE,
  group_order = NULL,
  order_x_mean = FALSE,
  coord_flip = TRUE,
  add_sig = TRUE,
  xtext_angle = 45,
  xtext_size = 13,
  ytitle_size = 17,
  ...
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{use_number}}{default 1:10; numeric vector; the sequences of taxa (1:n) selected in the plot; 
If n is larger than the number of total significant taxa, automatically use the total number as n.}

\item{\code{color_values}}{default \code{RColorBrewer::brewer.pal}(8, "Dark2"); color pallete for groups.}

\item{\code{select_taxa}}{default NULL; character vector to provide taxa names. 
The taxa names should be same with the names shown in the plot, not the 'Taxa' column names in \code{object$res_diff$Taxa}.}

\item{\code{simplify_names}}{default TRUE; whether use the simplified taxonomic name.}

\item{\code{keep_prefix}}{default TRUE; whether retain the taxonomic prefix.}

\item{\code{group_order}}{default NULL; a vector to order groups, i.e. reorder the legend and colors in plot; 
If NULL, the function can first check whether the group column of sample_table is factor. If yes, use the levels in it.
If provided, overlook the levels in the group of sample_table.}

\item{\code{order_x_mean}}{default FALSE; whether order the taxa in x axis by the means of abundances from large to small. 
If \code{TRUE}, all other factors in the data will become invalid.}

\item{\code{coord_flip}}{default TRUE; whether flip cartesian coordinates so that horizontal becomes vertical, and vertical becomes horizontal.}

\item{\code{add_sig}}{default TRUE; whether add the significance label to the plot.}

\item{\code{xtext_angle}}{default 45; number (e.g. 45). Angle of text in x axis.}

\item{\code{xtext_size}}{default 13; x axis text size. NULL means the default size in ggplot2. If \code{coord_flip = TRUE}, it represents the text size of the y axis.}

\item{\code{ytitle_size}}{default 17; y axis title size. If \code{coord_flip = TRUE}, it represents the title size of the x axis (i.e. "Relative abundance").}

\item{\code{...}}{parameters passed to \code{plot_alpha} function of \code{\link{trans_alpha}} class.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
ggplot.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\donttest{
t1 <- trans_diff$new(dataset = dataset, method = "anova", group = "Group", taxa_level = "Genus")
t1$plot_diff_abund(use_number = 1:10)
t1$plot_diff_abund(use_number = 1:10, add_sig = TRUE)
t1 <- trans_diff$new(dataset = dataset, method = "wilcox", group = "Group")
t1$plot_diff_abund(use_number = 1:20)
t1$plot_diff_abund(use_number = 1:20, add_sig = TRUE)
t1 <- trans_diff$new(dataset = dataset, method = "lefse", group = "Group")
t1$plot_diff_abund(use_number = 1:20)
t1$plot_diff_abund(use_number = 1:20, add_sig = TRUE)
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-trans_diff-plot_diff_bar"></a>}}
\if{latex}{\out{\hypertarget{method-trans_diff-plot_diff_bar}{}}}
\subsection{Method \code{plot_diff_bar()}}{
Bar plot for indicator index, such as LDA score and P value.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{trans_diff$plot_diff_bar(
  color_values = RColorBrewer::brewer.pal(8, "Dark2"),
  color_group_map = FALSE,
  use_number = 1:10,
  threshold = NULL,
  select_group = NULL,
  keep_full_name = FALSE,
  keep_prefix = TRUE,
  group_order = NULL,
  group_aggre = TRUE,
  group_two_sep = TRUE,
  coord_flip = TRUE,
  add_sig = FALSE,
  add_sig_increase = 0.1,
  add_sig_text_size = 5,
  xtext_angle = 45,
  xtext_size = 10,
  ytext_size = NULL,
  axis_text_y = deprecated(),
  heatmap_cell = "P.unadj",
  heatmap_sig = "Significance",
  heatmap_x = "Factors",
  heatmap_y = "Taxa",
  heatmap_lab_fill = "P value",
  ...
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{color_values}}{default \code{RColorBrewer::brewer.pal}(8, "Dark2"); colors palette for different groups.}

\item{\code{color_group_map}}{default FALSE; whether match the colors to groups in order to fix the color in each group when part of groups are not shown in the plot.
When \code{color_group_map = TRUE}, the group_order inside the object will be used as full groups set to guide the color extraction.}

\item{\code{use_number}}{default 1:10; numeric vector; the taxa numbers used in the plot, i.e. 1:n.}

\item{\code{threshold}}{default NULL; threshold value of indicators for selecting taxa, such as 3 for LDA score of LEfSe.}

\item{\code{select_group}}{default NULL; this is used to select the paired group when multiple comparisions are generated;
The input select_group must be one of \code{object$res_diff$Comparison}.}

\item{\code{keep_full_name}}{default FALSE; whether keep the taxonomic full lineage names.}

\item{\code{keep_prefix}}{default TRUE; whether retain the taxonomic prefix, such as "g__".}

\item{\code{group_order}}{default NULL; a vector to order the legend and colors in plot; 
If NULL, the function can first determine whether the group column of \code{microtable$sample_table} is factor. If yes, use the levels in it.
If provided, this parameter can overwrite the levels in the group of \code{microtable$sample_table}.}

\item{\code{group_aggre}}{default TRUE; whether aggregate the features for each group.}

\item{\code{group_two_sep}}{default TRUE; whether display the features of two groups on opposite sides of the coordinate axes when there are only two groups in total.}

\item{\code{coord_flip}}{default TRUE; whether flip cartesian coordinates so that horizontal becomes vertical, and vertical becomes horizontal.}

\item{\code{add_sig}}{default FALSE; whether add significance label (asterisk) above the bar.}

\item{\code{add_sig_increase}}{default 0.1; the axis position (\code{Value + add_sig_increase * max(Value)}) from which to add the significance label; 
only available when \code{add_sig = TRUE}.}

\item{\code{add_sig_text_size}}{default 5; the size of added significance label; only available when \code{add_sig = TRUE}.}

\item{\code{xtext_angle}}{default 45; number ranging from 0 to 90; used to make x axis text generate angle to reduce text overlap; 
only available when coord_flip = FALSE.}

\item{\code{xtext_size}}{default 10; text size of x axis.}

\item{\code{ytext_size}}{default NULL; text size of y axis. NULL means default ggplot2 value.}

\item{\code{axis_text_y}}{deprecated. Please use \code{ytext_size} argument instead.}

\item{\code{heatmap_cell}}{default "P.unadj"; the column of data for the cell of heatmap when formula with multiple factors is found in the method.}

\item{\code{heatmap_sig}}{default "Significance"; the column of data for the significance label of heatmap.}

\item{\code{heatmap_x}}{default "Factors"; the column of data for the x axis of heatmap.}

\item{\code{heatmap_y}}{default "Taxa"; the column of data for the y axis of heatmap.}

\item{\code{heatmap_lab_fill}}{default "P value"; legend title of heatmap.}

\item{\code{...}}{parameters passing to \code{geom_bar} for the bar plot or 
\code{plot_cor} function in \code{\link{trans_env}} class for the heatmap of multiple factors when formula is found in the method.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
ggplot.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\donttest{
t1$plot_diff_bar(use_number = 1:20)
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-trans_diff-plot_diff_cladogram"></a>}}
\if{latex}{\out{\hypertarget{method-trans_diff-plot_diff_cladogram}{}}}
\subsection{Method \code{plot_diff_cladogram()}}{
Plot the cladogram using taxa with significant difference.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{trans_diff$plot_diff_cladogram(
  color = RColorBrewer::brewer.pal(8, "Dark2"),
  group_order = NULL,
  use_taxa_num = 200,
  filter_taxa = NULL,
  use_feature_num = NULL,
  clade_label_level = 4,
  select_show_labels = NULL,
  only_select_show = FALSE,
  sep = "|",
  branch_size = 0.2,
  alpha = 0.2,
  clade_label_size = 2,
  clade_label_size_add = 5,
  clade_label_size_log = exp(1),
  node_size_scale = 1,
  node_size_offset = 1,
  annotation_shape = 22,
  annotation_shape_size = 5
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{color}}{default \code{RColorBrewer::brewer.pal}(8, "Dark2"); color palette used in the plot.}

\item{\code{group_order}}{default NULL; a vector to order the legend in plot; 
If NULL, the function can first check whether the group column of sample_table is factor. If yes, use the levels in it.
If provided, this parameter can overwrite the levels in the group of sample_table. 
If the number of provided group_order is less than the number of groups in \code{res_diff$Group}, the function will select the groups of group_order automatically.}

\item{\code{use_taxa_num}}{default 200; integer; The taxa number used in the background tree plot; select the taxa according to the mean abundance .}

\item{\code{filter_taxa}}{default NULL; The mean relative abundance used to filter the taxa with low abundance.}

\item{\code{use_feature_num}}{default NULL; integer; The feature number used in the plot; 
select the features according to the metric (method = "lefse" or "rf") from high to low.}

\item{\code{clade_label_level}}{default 4; the taxonomic level for marking the label with letters, root is the largest.}

\item{\code{select_show_labels}}{default NULL; character vector; The features to show in the plot with full label names, not the letters.}

\item{\code{only_select_show}}{default FALSE; whether only use the the select features in the parameter \code{select_show_labels}.}

\item{\code{sep}}{default "|"; the seperate character in the taxonomic information.}

\item{\code{branch_size}}{default 0.2; numberic, size of branch.}

\item{\code{alpha}}{default 0.2; shading of the color.}

\item{\code{clade_label_size}}{default 2; basic size for the clade label; please also see \code{clade_label_size_add} and \code{clade_label_size_log}.}

\item{\code{clade_label_size_add}}{default 5; added basic size for the clade label; see the formula in \code{clade_label_size_log} parameter.}

\item{\code{clade_label_size_log}}{default \code{exp(1)}; the base of \code{log} function for added size of the clade label; the size formula: 
\code{clade_label_size + log(clade_label_level + clade_label_size_add, base = clade_label_size_log)}; 
so use \code{clade_label_size_log}, \code{clade_label_size_add} and \code{clade_label_size}
can totally control the label size for different taxonomic levels.}

\item{\code{node_size_scale}}{default 1; scale for the node size.}

\item{\code{node_size_offset}}{default 1; offset for the node size.}

\item{\code{annotation_shape}}{default 22; shape used in the annotation legend.}

\item{\code{annotation_shape_size}}{default 5; size used in the annotation legend.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
ggplot.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
t1$plot_diff_cladogram(use_taxa_num = 100, use_feature_num = 30, select_show_labels = NULL)
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-trans_diff-clone"></a>}}
\if{latex}{\out{\hypertarget{method-trans_diff-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{trans_diff$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
