#' The dataset structured with microtable class for the demonstration of examples
#'
#' The dataset arose from 16S rRNA gene amplicon sequencing of wetland soils in China <doi:10.1016/j.geoderma.2018.09.035>. 
#' In \code{dataset$sample_table}, the 'Group' column means Chinese inland wetlands (IW), coastal wetland (CW) and Tibet plateau wetlands (TW).
#' The column 'Type' denotes the sampling region: northeastern region (NE), northwest region (NW), North China area (NC), 
#' middle-lower reaches of the Yangtze River (YML), southern coastal area (SC), upper reaches of the Yangtze River (YU) and Qinghai-Tibet Plateau (QTP). 
#' The column 'Saline' represents the saline soils and non-saline soils.
#'
#' \itemize{
#'   \item sample_table: sample information table
#'   \item otu_table: species-community abundance table
#'   \item tax_table: taxonomic table
#'   \item phylo_tree: phylogenetic tree
#'   \item taxa_abund: taxa abundance list with several tables for Phylum...Genus
#'   \item alpha_diversity: alpha diversity table
#'   \item beta_diversity: list with several beta diversity distance matrix
#' }
#'
#' @docType data
#' @keywords R6 object
#' @name dataset
#' @usage data(dataset)
#' @format An R6 class object
NULL

#' The environmental factors for the 16S example data
#'
#'
#' @docType data
#' @keywords data.frame
#' @name env_data_16S
#' @usage data(env_data_16S)
NULL


#' The OTU table of the 16S example data
#'
#'
#' @docType data
#' @keywords data.frame
#' @name otu_table_16S
#' @usage data(otu_table_16S)
NULL


#' The OTU table of the ITS example data
#'
#'
#' @docType data
#' @keywords data.frame
#' @name otu_table_ITS
#' @usage data(otu_table_ITS)
NULL


#' The phylogenetic tree of 16S example data
#'
#'
#' @docType data
#' @keywords data.frame
#' @name phylo_tree_16S
#' @usage data(phylo_tree_16S)
NULL


#' The modified FAPROTAX trait database
#'
#'
#' @docType data
#' @keywords data.frame
#' @name prok_func_FAPROTAX
#' @usage data(prok_func_FAPROTAX)
NULL


#' The modified NJC19 database
#'
#'
#' @docType data
#' @keywords data.frame
#' @name prok_func_NJC19_list
#' @usage data(prok_func_NJC19_list)
NULL


#' The FUNGuild database for fungi trait prediction
#'
#'
#' @docType data
#' @keywords data.frame
#' @name fungi_func_FUNGuild
#' @usage data(fungi_func_FUNGuild)
NULL


#' The FungalTraits database for fungi trait prediction
#'
#'
#' @docType data
#' @keywords data.frame
#' @name fungi_func_FungalTraits
#' @usage data(fungi_func_FungalTraits)
NULL


#' The KEGG data files used in the trans_func class
#'
#'
#' @docType data
#' @keywords list
#' @name Tax4Fun2_KEGG
#' @usage data(Tax4Fun2_KEGG)
NULL


#' The sample information of 16S example data
#'
#'
#' @docType data
#' @keywords data.frame
#' @name sample_info_16S
#' @usage data(sample_info_16S)
NULL


#' The sample information of ITS example data
#'
#'
#' @docType data
#' @keywords data.frame
#' @name sample_info_ITS
#' @usage data(sample_info_ITS)
NULL


#' The taxonomic information of 16S example data
#'
#'
#' @docType data
#' @keywords data.frame
#' @name taxonomy_table_16S
#' @usage data(taxonomy_table_16S)
NULL


#' The taxonomic information of ITS example data
#'
#'
#' @docType data
#' @keywords data.frame
#' @name taxonomy_table_ITS
#' @usage data(taxonomy_table_ITS)
NULL
