% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prodigal.R
\name{prodigal}
\alias{prodigal}
\title{Gene predictions using Prodigal}
\usage{
prodigal(genome.file, prot.file = NULL, nuc.file = NULL,
  closed.ends = TRUE, motif.scan = FALSE)
}
\arguments{
\item{genome.file}{Name of a FASTA formatted file with all the DNA sequences for a genome (chromosomes,
plasmids, contigs etc.).}

\item{prot.file}{If specified, amino acid sequence of each protein is written to this FASTA file.}

\item{nuc.file}{If specified, nucleotide sequence of each protein is written to this FASTA file.}

\item{closed.ends}{Logical, if \code{TRUE} genes are not allowed to run off edges (default \code{TRUE}).}

\item{motif.scan}{Logical, if \code{TRUE} forces motif scan instead of Shine-Dalgarno trainer (default 
\code{FALSE}).}
}
\value{
A \code{gff.table} with the metadata for all predicted genes (see \code{\link{readGFF}}). If
\code{prot.file} is specified, a FASTA formatted file with predicted protein sequences are also produced. If
\code{nuc.file} is specified, a similar file with nucleotide sequences is also produced.
}
\description{
Finds coding genes in a genome using the Prodigal software.
}
\details{
This function sets up a call to the software Prodigal (Hyatt et al, 2009). This software is
designed to find coding genes in prokaryote genomes. It runs fast and has obtained very good results in
tests among the automated gene finders. The options used as default here are believed to be the best for
pan-genomic analyses.
}
\note{
The Prodigal software must be installed on the system for this function to work, i.e. the command 
\samp{system("prodigal -h")} (no version numbers!) must be recognized as a valid command if you run it 
in the Console window.
}
\examples{
\dontrun{
# This example requires the external Prodigal software
# Using a genome file in this package
xpth <- file.path(path.package("micropan"),"extdata")
genome.file <- file.path(xpth,"Example_genome.fasta.xz")

# We need to uncompress it first...
tf <- tempfile(fileext=".xz")
s <- file.copy(genome.file,tf)
tf <- xzuncompress(tf)

# Calling Prodigal, and writing all predicted proteins to a file as well
prot.file <- tempfile(fileext=".fasta")
gff.table <- prodigal(tf,prot.file)

# Reading protein file as well
proteins <- readFasta(prot.file)

# ...and cleaning...
s <- file.remove(tf,prot.file)
}

}
\references{
Hyatt, D., Chen, G., LoCascio, P.F., Land, M.L., Larimer, F.W., Hauser, L.J. (2010).
Prodigal: prokaryotic gene recognition and translation initiation site identification, BMC Bioinformatics,
11:119.
}
\seealso{
\code{\link{readGFF}}.
}
\author{
Lars Snipen and Kristian Hovde Liland.
}
