% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fastq.R
\name{plot.Fastq}
\alias{plot.Fastq}
\alias{summary.Fastq}
\alias{summary.Fastq}
\title{Plotting and summary of \code{Fastq} objects}
\usage{
\method{plot}{Fastq}(x, y = NULL, col = "tan4", border = "tan4", ...)

\method{summary}{Fastq}(object, ...)
}
\arguments{
\item{x}{A \code{Fastq} object, see below.}

\item{y}{not used.}

\item{col}{Color of bar interiors.}

\item{border}{Color of bar borders.}

\item{...}{Optional graphical arguments.}

\item{object}{A \code{Fastq} object, see below.}
}
\description{
Generic functions for plotting and printing the content of a \code{Fastq} object.
}
\details{
A \code{Fastq} object contains biological sequences in the FASTQ format. It is a small (S3)
extension to a \code{data.frame}. It is actually a \code{data.frame} containing at least three text columns
named \samp{Header}, \samp{Sequence} and \samp{Quality}. The \samp{Header} column contains the headerlines
for each sequence, the \samp{Sequence} columns the sequences themselves and the \samp{Quality} the base-quality
sequence. A \code{Fastq} object is typically created by reading
a FASTQ formatted file into R by \code{\link{readFastq}}.

A \code{Fastq} object can be treated as a \code{data.frame}, which makes it quick and easy to search both
for specific regular expressions, sort or re-arrange the ordering of the sequences,
extract subsets or add new data to an existing \code{Fastq} object.

A \code{Fastq} object can also be treated as a \code{Fasta} object. Using \code{\link{writeFasta}}
will write the \code{Fastq} to a file in \code{Fasta} format.

The \code{plot.Fastq} function will display the content of the \code{Fastq} object as a histogram over
the lengths of the sequences. 

The \code{summary.Fastq} function will display a text giving the number of sequences and the alphabet,
i.e. listing all unique symbols found in the file.
}
\examples{
# See the examples in the Help-file for readFastq/writeFastq

}
\seealso{
\code{\link{readFastq}}, \code{\link{writeFastq}}.
}
\author{
Lars Snipen and Kristian Hovde Liland.
}
